/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.race;

import com.google.common.collect.Lists;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.Replay;
import com.mcsrranked.client.anticheat.replay.ReplayProcessor;
import com.mcsrranked.client.anticheat.replay.file.ReplayManager;
import com.mcsrranked.client.anticheat.replay.file.ReplayRecordFile;
import com.mcsrranked.client.anticheat.replay.tracking.PersonalPlayerTracker;
import com.mcsrranked.client.config.RankedGameRules;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.screen.race.RaceInfoScreen;
import com.mcsrranked.client.gui.screen.race.RaceResultScreen;
import com.mcsrranked.client.info.RunTimer;
import com.mcsrranked.client.info.race.RaceFlag;
import com.mcsrranked.client.info.race.RaceTimeline;
import com.mcsrranked.client.info.race.WeeklyRaceRecord;
import com.mcsrranked.client.info.race.WeeklyRaceResult;
import com.mcsrranked.client.socket.SocketInstance;
import com.mcsrranked.client.utils.ClientUtils;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_437;

public class WeeklyRace {
    private final int id;
    private final SeedPair seed;
    private final int endsAt;
    private final List<WeeklyRaceRecord> leaderboard;
    private final WeeklyRaceRecord user;
    private WeeklyRaceRecord ghost;
    private boolean isRunning = false;
    private boolean isPracticing = false;
    private RunTimer runTimer = new RunTimer();
    private final List<RaceTimeline> currentTimelines = Lists.newArrayList();
    private Replay replay = null;
    private ReplayProcessor replayProcessor = null;
    private WeeklyRaceResult result = null;

    public WeeklyRace(int id, SeedPair seed, int endsAt, List<WeeklyRaceRecord> leaderboard, WeeklyRaceRecord user) {
        this.id = id;
        this.seed = seed;
        this.endsAt = endsAt;
        this.leaderboard = leaderboard;
        this.user = user;
    }

    public int getID() {
        return this.id;
    }

    public long getOverworldSeed() {
        return ClientUtils.getSeedFromString(this.seed.overworld);
    }

    public long getNetherSeed() {
        return ClientUtils.getSeedFromString(this.seed.nether);
    }

    public long getTheEndSeed() {
        return ClientUtils.getSeedFromString(this.seed.theEnd);
    }

    public long getRNGSeed() {
        return ClientUtils.getSeedFromString(this.seed.rng);
    }

    public RaceFlag getFlags() {
        return this.seed.getFlags();
    }

    public WeeklyRaceRecord getUser() {
        return this.user;
    }

    public List<WeeklyRaceRecord> getLeaderboard() {
        return this.leaderboard;
    }

    public Date getEndDate() {
        return new Date((long)this.endsAt * 1000L);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isPracticing() {
        return this.isPracticing;
    }

    public void setPracticing(boolean practicing) {
        this.isPracticing = practicing;
    }

    public boolean isPlaying() {
        return this.isRunning() || this.isPracticing();
    }

    public List<RaceTimeline> getCurrentTimelines() {
        return this.currentTimelines;
    }

    public WeeklyRaceRecord getGhost() {
        return this.ghost;
    }

    public void setGhost(WeeklyRaceRecord ghost) {
        this.ghost = ghost;
    }

    public void initReplay(boolean enableTracking) {
        File replayFile;
        this.replayProcessor = null;
        this.replay = new Replay(MCSRRankedClient.LOCAL_REPLAY_SIGNED_KEY);
        this.replay.getPersonalPlayerTracker().setActiveType(enableTracking ? PersonalPlayerTracker.ActiveType.RACE : PersonalPlayerTracker.ActiveType.NONE);
        this.replay.getPersonalPlayerTracker().setRange(24);
        if (this.getGhost() != null && (replayFile = ReplayManager.downloadReplayFile(this, this.getGhost())) != null) {
            try {
                ReplayRecordFile replay = ReplayManager.convertReplayFile(replayFile);
                ReplayProcessor processor = replay.getProcessor();
                processor.enableGhostOnly();
                processor.setActive(false);
                this.replayProcessor = processor;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void resetReplay() {
        this.getReplay().reset();
        if (this.replayProcessor != null) {
            this.replayProcessor.reset();
        }
    }

    public void resetTimer() {
        this.runTimer = new RunTimer();
        this.runTimer.setWorldLoadPauseLimit(3000L, 1);
    }

    public Replay getReplay() {
        return this.replay;
    }

    public ReplayProcessor getReplayProcessor() {
        return this.replayProcessor;
    }

    public void setRunning(boolean running) {
        this.getCurrentTimelines().clear();
        this.isRunning = running;
    }

    public RunTimer getRunTimer() {
        return this.runTimer;
    }

    public WeeklyRaceResult getResult() {
        return this.result;
    }

    public void setResult(WeeklyRaceResult result) {
        this.result = result;
    }

    public void onComplete() {
        long finalTime = this.getRunTimer().getIGT();
        this.getReplay().getPersonalPlayerTracker().stopTracking();
        this.setResult(new WeeklyRaceResult(this, finalTime));
        this.getResult().submit(0);
        class_310 client = class_310.method_1551();
        RaceResultScreen resultScreen = new RaceResultScreen((class_437)new RaceInfoScreen(), this);
        client.method_1507((class_437)resultScreen);
        client.field_1705.method_1763((class_2561)(this.getUser() != null && (long)this.getUser().getTime() > finalTime ? new class_2588("projectelo.title.new_best").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}) : new class_2588("projectelo.title.completed").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})), null, 0, 0, 0);
        client.field_1705.method_1763(null, (class_2561)new class_2588("projectelo.text.match.final_time").method_10852((class_2561)new class_2585(String.format(" (%s)", InGameTimerUtils.timeToStringFormat((long)finalTime))).method_27692(class_124.field_1075)), 0, 0, 0);
        client.field_1705.method_1763(null, null, 20, 120, 20);
        MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
            try {
                Thread.sleep(1000L);
                ClientUtils.playSound(class_3417.field_15195, 1.0f, ((Float)SpeedRunOption.getOption(RankedOptions.END_SOUND_VOLUME)).floatValue());
                Thread.sleep(9000L);
                resultScreen.markEnd();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public Consumer<class_1928> getGameRuleConsumer() {
        return gameRules -> {
            ((class_1928.class_4310)gameRules.method_20746(RankedGameRules.CLEAN_SPAWN_BLOCK_ENTITIES)).method_20758(this.getFlags().isEnableFlag(RaceFlag.Type.CLEAN_SPAWN), null);
            ((class_1928.class_4310)gameRules.method_20746(RankedGameRules.GENERATE_ARTIFICIAL_LAVA_POOLS)).method_20758(this.getFlags().isEnableFlag(RaceFlag.Type.GENERATE_ARTIFICIAL_LAVA_POOLS), null);
            ((class_1928.class_4310)gameRules.method_20746(RankedGameRules.NO_MONSTER_SPAWN_IN_BASTION)).method_20758(this.getFlags().isEnableFlag(RaceFlag.Type.NO_MONSTER_SPAWN_IN_BASTION), null);
            ((class_1928.class_4310)gameRules.method_20746(RankedGameRules.STANDARDIZED_DRAGON_PATH)).method_20758(this.getFlags().isEnableFlag(RaceFlag.Type.STANDARDIZED_DRAGON_PATH), null);
            ((class_1928.class_4310)gameRules.method_20746(RankedGameRules.LOWER_DRAGON_FIRST_NODE)).method_20758(this.getFlags().isEnableFlag(RaceFlag.Type.LOWER_DRAGON_FIRST_NODE), null);
            ((class_1928.class_4310)gameRules.method_20746(RankedGameRules.MODIFIED_LOOT_TABLES)).method_20758(this.getFlags().isEnableFlag(RaceFlag.Type.MODIFIED_LOOT_TABLES), null);
            ((class_1928.class_4310)gameRules.method_20746(RankedGameRules.IMMEDIATELY_DRAGON_PERCH)).method_20758(this.getFlags().isEnableFlag(RaceFlag.Type.IMMEDIATELY_DRAGON_PERCH), null);
            if (this.getID() == 1) {
                ((class_1928.class_4310)gameRules.method_20746(RankedGameRules.STANDARDIZED_DRAGON_PATH)).method_20758(true, null);
            }
            if (this.getID() <= 3) {
                ((class_1928.class_4310)gameRules.method_20746(RankedGameRules.STANDARDIZED_FORTRESS_SPAWN)).method_20758(false, null);
            }
        };
    }

    static {
        SocketInstance.on("p$race_phase", payload -> {
            if (MCSRRankedClient.getCurrentRace().map(race -> race.getResult() != null).orElse(false).booleanValue()) {
                MCSRRankedClient.getCurrentRace().get().getResult().submit(payload.getNextInteger());
            }
        });
    }

    public static class SeedPair {
        private final String overworld;
        private final String nether;
        private final String theEnd;
        private final String rng;
        private final Integer flags;

        private SeedPair(String overworld, String nether, String theEnd, String rng, Integer flags) {
            this.overworld = overworld;
            this.nether = nether;
            this.theEnd = theEnd;
            this.rng = rng;
            this.flags = flags;
        }

        public RaceFlag getFlags() {
            return this.flags == null ? RaceFlag.getDefault() : new RaceFlag(this.flags);
        }
    }
}

