/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.mixin.player;

import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.config.RankedGameRules;
import com.mcsrranked.client.info.match.MatchSplit;
import com.mcsrranked.client.info.match.MatchType;
import com.mcsrranked.client.info.match.online.InventoryParser;
import com.mcsrranked.client.info.match.online.MatchFlag;
import com.mcsrranked.client.info.match.online.MatchStatus;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.socket.SocketInstance;
import com.mcsrranked.client.world.BlindState;
import com.mcsrranked.client.world.CommandSetupState;
import com.mcsrranked.client.world.RunSplitState;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3442;
import net.minecraft.class_3468;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.include.com.google.common.collect.Lists;

@Mixin(value={class_3222.class})
public abstract class MixinServerPlayerEntity
extends class_1657 {
    @Shadow
    @Final
    public class_3225 field_13974;
    @Shadow
    @Final
    private class_3442 field_13966;
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Shadow
    private class_5321<class_1937> field_23191;
    @Shadow
    @Nullable
    private class_2338 field_23192;
    @Unique
    private static class_2338 lastPortalPos = null;
    @Unique
    private int inventoryUpdateTick = 0;
    @Unique
    private String lastInventoryParse = "";

    @Shadow
    public abstract void method_5859(double var1, double var3, double var5);

    @Shadow
    public abstract void method_9203(class_2561 var1, UUID var2);

    @Shadow
    protected abstract void method_5623(double var1, boolean var3, class_2680 var4, class_2338 var5);

    @Shadow
    public abstract class_3218 method_14220();

    @Shadow
    @Nullable
    public abstract class_2338 method_26280();

    public MixinServerPlayerEntity(class_1937 world, class_2338 blockPos, GameProfile gameProfile) {
        super(world, blockPos, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onInit(MinecraftServer server, class_3218 world, GameProfile profile, class_3225 interactionManager, CallbackInfo ci) {
        MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            if (!onlineMatch.getStatus().isPlaying()) {
                return;
            }
            if (onlineMatch.getOption().getFlag().isEnableFlag(MatchFlag.Type.ICARUS)) {
                class_1799 elytra = new class_1799((class_1935)class_1802.field_8833);
                elytra.method_7948().method_10556("Unbreakable", true);
                this.field_7514.field_7548.set(2, (Object)elytra);
                class_1799 fireworks = new class_1799((class_1935)class_1802.field_8639, 64);
                fireworks.method_7911("Fireworks").method_10569("Flight", 3);
                this.field_7514.field_7547.set(0, (Object)fireworks);
            }
            if (onlineMatch.getOption().getFlag().isEnableFlag(MatchFlag.Type.HALF_HEART)) {
                this.method_6033(1.0f);
                Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(1.0);
            }
        });
    }

    @Inject(method={"changeDimension"}, at={@At(value="HEAD")})
    public void onChangeDimension(class_3218 destination, CallbackInfoReturnable<class_1297> cir) {
        if (this.method_5770().method_27983() == class_3218.field_25179) {
            MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getLocalData().setLastOverworldPos((class_2382)new class_2338((class_2382)this.method_24515())));
        }
        lastPortalPos = this.method_24515();
    }

    @Inject(method={"playerTick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        String invParse;
        CommandSetupState commandSetupState = (CommandSetupState)this.field_13995.method_30002().method_17983().method_17924(CommandSetupState::new, "command_setup");
        if (!commandSetupState.isCommandSetup() && MCSRRankedClient.getOnlineMatch().map(onlineMatch -> onlineMatch.getStatus().isPlaying()).orElse(false).booleanValue() && this.field_13966.method_15024(class_3468.field_15419, (Object)class_3468.field_15417) >= 20 && MCSRRankedClient.getOnlineMatch().get().getOption().getCommand() != null && !MCSRRankedClient.LOCAL_PLAYER.isSpectator()) {
            this.field_13995.method_3760().method_14607(true);
            for (String command : Objects.requireNonNull(MCSRRankedClient.getOnlineMatch().get().getOption().getCommand()).split(";")) {
                this.field_13995.method_3734().method_9249(this.method_5671(), command);
            }
            this.field_13995.execute(() -> this.field_13995.method_3760().method_14607(false));
            commandSetupState.setCommandSetup(true);
        }
        ArrayList totalInv = Lists.newArrayList();
        totalInv.addAll(this.field_7514.field_7547);
        totalInv.addAll(this.field_7514.field_7544);
        totalInv.addAll(this.field_7514.field_7548);
        if (this.inventoryUpdateTick > 0) {
            --this.inventoryUpdateTick;
        }
        if (MCSRRankedClient.getOnlineMatch().map(match -> match.getStatus().isPlaying()).orElse(false).booleanValue() && MCSRRankedClient.getOnlineMatch().get().getReplay().getPersonalPlayerTracker().isActive() && this.inventoryUpdateTick == 0 && !Objects.equals(this.lastInventoryParse, invParse = InventoryParser.toString(totalInv))) {
            this.lastInventoryParse = invParse;
            this.inventoryUpdateTick = 100;
            SocketInstance.getInstance().emit("p$inventory", this.lastInventoryParse);
        }
        BlindState blindState = (BlindState)this.field_13995.method_30002().method_17983().method_17924(BlindState::new, "blind_state");
        RunSplitState splitState = RunSplitState.fromServer(this.field_13995);
        if (!blindState.isBlinded() && this.field_6002.method_27983() == class_1937.field_25179 && lastPortalPos != null) {
            boolean blaze = false;
            boolean pearl = false;
            for (class_1799 itemStack : totalInv) {
                if (itemStack == null) continue;
                if (itemStack.method_7909() == class_1802.field_8634) {
                    pearl = true;
                }
                if (itemStack.method_7909() == class_1802.field_8894) {
                    blaze = true;
                }
                if (itemStack.method_7909() == class_1802.field_8183) {
                    blaze = true;
                }
                if (itemStack.method_7909() != class_1802.field_8449) continue;
                pearl = true;
                blaze = true;
                break;
            }
            if (blaze && pearl) {
                if (MCSRRankedClient.getOnlineMatch().map(match -> match.getStatus() == MatchStatus.RUNNING && match.isGameplayInteractable()).orElse(false).booleanValue()) {
                    SocketInstance.getInstance().emit("p$timeline", "projectelo.timeline.blind_travel", true, lastPortalPos.method_23854().trim());
                }
                splitState.addSplit(MatchSplit.BLINDED, this);
                blindState.setBlinded(true);
            }
        }
        splitState.addSplit(MatchSplit.STARTED, this);
        if (this.method_5770().method_27983() == class_3218.field_25179) {
            MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getLocalData().setLastOverworldPos((class_2382)new class_2338((class_2382)this.method_24515())));
        }
        MCSRRankedClient.getOnlineMatch().ifPresent(match -> {
            if (!match.getLocalData().hasEquipArmor()) {
                for (class_1799 itemStack : this.field_7514.field_7548) {
                    if (itemStack == null || !(itemStack.method_7909() instanceof class_1738)) continue;
                    match.getLocalData().setHasEquipArmor();
                }
            }
            if (match.getType() == MatchType.RANKED && match.getStatus() == MatchStatus.RUNNING) {
                if (Math.random() < (double)0.02f && (this.field_13995.method_3760().method_14579() || this.field_13974.method_14257() == class_1934.field_9220)) {
                    SocketInstance.getInstance().close();
                }
                if (match.getLocalData().getBlindLevel() < 2) {
                    int currentLevel;
                    int blazePowders = 0;
                    int pearls = 0;
                    for (class_1799 itemStack : totalInv) {
                        if (itemStack == null) continue;
                        if (itemStack.method_7909() == class_1802.field_8634) {
                            pearls += itemStack.method_7947();
                        }
                        if (itemStack.method_7909() == class_1802.field_8894) {
                            blazePowders += itemStack.method_7947() * 2;
                        }
                        if (itemStack.method_7909() == class_1802.field_8183) {
                            blazePowders += itemStack.method_7947();
                        }
                        if (itemStack.method_7909() != class_1802.field_8449) continue;
                        pearls += itemStack.method_7947();
                        blazePowders += itemStack.method_7947();
                        break;
                    }
                    int level = 0;
                    if (blazePowders >= 10) {
                        ++level;
                    }
                    if (pearls >= 10) {
                        ++level;
                    }
                    if ((currentLevel = match.getLocalData().getBlindLevel()) < level) {
                        match.getLocalData().setBlindLevel(level);
                        SocketInstance.getInstance().emit("p$blind_level", level);
                    }
                }
            }
        });
        if (splitState.shouldUpdateBeginnerSpawn()) {
            for (int cx = -1; cx <= 1; ++cx) {
                for (int cz = -1; cz <= 1; ++cz) {
                    if (this.field_6002.method_8393(this.field_6024 + cx, this.field_5980 + cz)) continue;
                    return;
                }
            }
            if (this.field_6002.method_20812(null, new class_238((double)this.method_24515().method_10263() + 0.5 - 1.25, (double)this.method_24515().method_10264(), (double)this.method_24515().method_10260() + 0.5 - 1.25, (double)this.method_24515().method_10263() + 0.5 + 1.25, (double)(this.method_24515().method_10264() + 3), (double)this.method_24515().method_10260() + 0.5 + 1.25)).allMatch(class_265::method_1110)) {
                boolean centerFilled = false;
                int safeFaces = 0;
                for (int px = -1; px <= 1; ++px) {
                    for (int pz = -1; pz <= 1; ++pz) {
                        class_2338 blockPos = this.method_24515().method_10069(px, -1, pz);
                        if (!this.field_6002.method_8320(blockPos).method_26207().method_15801()) continue;
                        if (px == 0 && pz == 0) {
                            centerFilled = true;
                            continue;
                        }
                        ++safeFaces;
                    }
                }
                if (safeFaces >= 3 && centerFilled) {
                    splitState.setBeginnerSpawn((class_5321<class_1937>)this.field_6002.method_27983(), this.method_24515());
                }
            }
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="RETURN")})
    public void injectOnDeath(class_1282 source, CallbackInfo ci) {
        boolean isDeathReset = false;
        if (this.field_23192 != null && this.field_23191.method_29177().equals((Object)this.field_6002.method_27983().method_29177()) && this.field_23192.method_19771((class_2382)this.method_24515(), 48.0)) {
            isDeathReset = true;
        }
        if (MCSRRankedClient.getOnlineMatch().isPresent()) {
            OnlineMatch matchInfo = MCSRRankedClient.getOnlineMatch().get();
            if (!matchInfo.getStatus().isPlaying() || !matchInfo.isGameplayInteractable()) {
                return;
            }
            SocketInstance.getInstance().emit("p$timeline", "projectelo.timeline.death" + (isDeathReset ? "_spawnpoint" : ""), false, this.method_24515().method_23854().trim());
        }
        RunSplitState.fromServer(this.field_13995).addDeathPoint(this);
    }

    protected void method_5825() {
        if (this.field_13974.method_14257() == class_1934.field_9219) {
            return;
        }
        super.method_5825();
    }

    @Inject(method={"getSpawnPointPosition"}, at={@At(value="RETURN")}, cancellable=true)
    public void onGetSpawnPos(CallbackInfoReturnable<class_2338> cir) {
        class_3545<class_5321<class_1937>, class_2338> beginnerSpawn = RunSplitState.fromServer(this.field_13995).getBeginnerSpawn();
        if (beginnerSpawn == null) {
            return;
        }
        if (cir.getReturnValue() != null && this.field_6002.method_27983().equals(this.field_23191) && ((class_2338)cir.getReturnValue()).method_19769((class_2374)this.method_19538(), 64.0)) {
            return;
        }
        if (this.method_14220().method_8450().method_8355(RankedGameRules.RESPAWN_AT_MAJOR_SPLIT)) {
            cir.setReturnValue((Object)((class_2338)beginnerSpawn.method_15441()));
        }
    }

    @Inject(method={"getSpawnPointDimension"}, at={@At(value="RETURN")}, cancellable=true)
    public void onGetSpawnDimension(CallbackInfoReturnable<class_5321<class_1937>> cir) {
        class_3545<class_5321<class_1937>, class_2338> beginnerSpawn = RunSplitState.fromServer(this.field_13995).getBeginnerSpawn();
        if (beginnerSpawn == null) {
            return;
        }
        if (this.method_26280() != beginnerSpawn.method_15441()) {
            return;
        }
        if (this.method_14220().method_8450().method_8355(RankedGameRules.RESPAWN_AT_MAJOR_SPLIT)) {
            cir.setReturnValue((Object)((class_5321)beginnerSpawn.method_15442()));
        }
    }

    @Inject(method={"isSpawnPointSet"}, at={@At(value="RETURN")}, cancellable=true)
    public void onSpawnPointSet(CallbackInfoReturnable<Boolean> cir) {
        class_3545<class_5321<class_1937>, class_2338> beginnerSpawn = RunSplitState.fromServer(this.field_13995).getBeginnerSpawn();
        if (beginnerSpawn == null) {
            return;
        }
        if (this.method_26280() != beginnerSpawn.method_15441()) {
            return;
        }
        if (this.method_14220().method_8450().method_8355(RankedGameRules.RESPAWN_AT_MAJOR_SPLIT)) {
            cir.setReturnValue((Object)true);
        }
    }
}

