/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.socket;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.auth.ClientAuth;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.MessageToast;
import com.mcsrranked.client.gui.screen.ModUpdateScreen;
import com.mcsrranked.client.gui.screen.RankedMainScreen;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.toast.ToastHud;
import com.mcsrranked.client.info.BannerInfo;
import com.mcsrranked.client.info.match.EventMode;
import com.mcsrranked.client.info.match.online.MatchArgument;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.info.player.PlayerConnections;
import com.mcsrranked.client.info.player.PlayerPermission;
import com.mcsrranked.client.info.player.achievement.PlayerAchievement;
import com.mcsrranked.client.socket.SocketEvent;
import com.mcsrranked.client.socket.SocketStatus;
import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.utils.DiscordRPCUtils;
import com.mcsrranked.client.utils.SSLFixer;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.engineio.client.EngineIOException;
import java.net.URI;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.json.JSONObject;

public class SocketInstance {
    private static SocketInstance instance = null;
    private static Map<String, String> authMap = null;
    private static boolean afkStatus = false;
    public static String[] BAN_INFO = null;
    private Socket socket = null;
    private SocketStatus status = SocketStatus.NONE;
    private final Map<String, Object[]> sendPackets = Maps.newConcurrentMap();

    public static SocketInstance getInstance() {
        if (instance == null) {
            instance = new SocketInstance();
        }
        return instance;
    }

    private static void onDisconnect() {
        MCSRRankedClient.resetOnlinePlay();
        MCSRRankedClient.setCurrentQueue(null);
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            ClientUtils.addMessage((class_2561)new class_2588("projectelo.text.disconnected_server." + (afkStatus ? "afk" : "normal")).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
            ClientUtils.playSound(class_3417.field_14879, 0.0f, ((Float)SpeedRunOption.getOption(RankedOptions.DISCONNECT_SOUND_VOLUME)).floatValue());
            if (client.field_1724 == null) {
                client.method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)("projectelo.text.disconnected_server." + (afkStatus ? "afk" : "normal")), (Object[])new Object[0])));
            }
            if (client.field_1755 instanceof RankedScreen) {
                client.method_1507((class_437)RankedMainScreen.createIgnoreConnection());
            }
        });
    }

    private static boolean checkUpdate(String version, String downloadUrl) {
        int versionCompare = 0;
        try {
            versionCompare = Version.parse((String)version).compareTo((Object)MCSRRankedClient.MOD_CONTAINER.getMetadata().getVersion());
        }
        catch (VersionParsingException e) {
            e.printStackTrace();
        }
        if (versionCompare > 0) {
            class_310.method_1551().execute(() -> {
                SocketInstance.getInstance().setStatus(SocketStatus.OUTDATED);
                class_310.method_1551().method_1507((class_437)new ModUpdateScreen(downloadUrl, version, (class_437)new class_442()));
            });
            return true;
        }
        return false;
    }

    private SocketInstance() {
    }

    public void connect() {
        if (this.socket != null && this.socket.connected()) {
            return;
        }
        this.setStatus(SocketStatus.AUTHENTICATING);
        ClientAuth auth = ClientAuth.getInstance();
        if (auth == null) {
            this.setStatus(SocketStatus.FAILED_AUTH);
            return;
        }
        if (authMap == null) {
            authMap = auth.createMessageJson(class_310.method_1551().method_1548().method_1676(), String.valueOf(class_155.method_16673().getWorldVersion()));
        }
        if (this.socket == null) {
            IO.Options options = IO.Options.builder().setTransports(new String[]{"websocket"}).setAuth(authMap).setReconnectionAttempts(5).setReconnectionDelay(1500L).build();
            options.callFactory = SSLFixer.OK_HTTP_CLIENT;
            options.webSocketFactory = SSLFixer.OK_HTTP_CLIENT;
            this.socket = IO.socket(URI.create(MCSRRankedClient.getServerUrl("ws")), options);
        }
        this.onIO("reconnect", payload -> {
            MCSRRankedClient.LOGGER.info("reconnected: " + payload.toString());
            this.setStatus(SocketStatus.CONNECTED);
            for (Map.Entry<String, Object[]> entry : this.sendPackets.entrySet()) {
                this.emit(entry.getKey(), entry.getValue());
            }
        });
        SocketInstance.on("disconnect", payload -> {
            MCSRRankedClient.LOGGER.info("disconnected: " + payload.toString());
            this.setStatus(SocketStatus.DISCONNECTED);
            if (payload.getNextString().equals("io server disconnect")) {
                SocketInstance.onDisconnect();
            }
        });
        SocketInstance.on("connect_error", payload -> {
            MCSRRankedClient.LOGGER.info("Connection Error: " + payload.toString());
            Object object = payload.next();
            if (!(object instanceof EngineIOException)) {
                JsonObject jsonObject;
                this.setStatus(SocketStatus.FAILED_AUTH);
                if (object instanceof JSONObject && (jsonObject = new JsonParser().parse(object.toString()).getAsJsonObject()).has("message")) {
                    String errorMessage = jsonObject.get("message").getAsString();
                    if (errorMessage.startsWith("ban:")) {
                        BAN_INFO = errorMessage.split(":");
                        this.setStatus(SocketStatus.BANNED);
                    }
                    if (errorMessage.equals("max_connections")) {
                        this.setStatus(SocketStatus.MAX_CONNECTIONS);
                    }
                }
            }
            if (object instanceof Throwable) {
                ((Throwable)object).printStackTrace();
            }
        });
        this.onIO("error", payload -> MCSRRankedClient.LOGGER.info("Socket Error: " + payload.toString()));
        this.onIO("reconnect_error", payload -> MCSRRankedClient.LOGGER.info("Socket Reconnect Error: " + payload.toString()));
        this.onIO("reconnect_failed", payload -> {
            MCSRRankedClient.LOGGER.info("Socket Failed: " + payload.toString());
            this.setStatus(this.getStatus().isLoading() ? SocketStatus.ERROR : SocketStatus.DISCONNECTED);
            SocketInstance.onDisconnect();
        });
        SocketInstance.on("hello", payload -> {
            try {
                SocketInstance.getInstance().setStatus(SocketStatus.CONNECTED);
                MCSRRankedClient.LOCAL_PLAYER = OnlinePlayer.of(payload.getNextString());
                MCSRRankedClient.PLAYER_CONNECTIONS = PlayerConnections.of(payload.getNextString());
                MCSRRankedClient.PLAYER_PERMISSION = PlayerPermission.of(payload.getNextString());
                MCSRRankedClient.LOCAL_REPLAY_SIGNED_KEY = payload.getNextString();
                MCSRRankedClient.MATCH_ARGUMENT = MatchArgument.of(payload.getNextString());
                authMap.put("elo-socket-id", payload.getNextString());
                DiscordRPCUtils.start();
                if (MCSRRankedClient.getOnlineMatch().isPresent()) {
                    ClientUtils.playSound(class_3417.field_15008, 1.0f, 0.7f);
                    ClientUtils.addMessage((class_2561)new class_2588("projectelo.text.disconnected_server.success_match_end").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
                }
                MCSRRankedClient.resetOnlinePlay();
                MCSRRankedClient.setCurrentQueue(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                SocketInstance.getInstance().setStatus(SocketStatus.ERROR);
                SocketInstance.getInstance().close();
            }
        });
        SocketInstance.on("update", payload -> {
            if (!SocketInstance.checkUpdate(payload.getNextString(), payload.getNextString())) {
                class_310.method_1551().method_1507(null);
            }
        });
        SocketInstance.on("p$refresh", payload -> {
            MCSRRankedClient.BANNER_INFO = (BannerInfo)MCSRRankedClient.GSON.fromJson(payload.getNextString(), BannerInfo.class);
            MCSRRankedClient.CURRENT_EVENT = (EventMode)MCSRRankedClient.GSON.fromJson(payload.getNextString(), EventMode.class);
        });
        SocketInstance.on("p$achieve", payload -> {
            String achievementID = payload.getNextString();
            int level = payload.getNextInteger();
            String[] data = new String[]{};
            if (payload.hasNext()) {
                JsonArray arrayData = payload.getNextJsonArray();
                data = new String[arrayData.size()];
                for (int i = 0; i < arrayData.size(); ++i) {
                    data[i] = arrayData.get(i).getAsString();
                }
            }
            ToastHud.addQueue(new PlayerAchievement(achievementID, ClientUtils.getUnixTime(), data, level, null, null));
        });
        SocketInstance.on("p$afk", payload -> {
            afkStatus = true;
        });
        this.socket.offAnyIncoming();
        this.socket.onAnyIncoming(args -> {
            if (args[0].toString().equals("r")) {
                return;
            }
            this.emit("r", args[0].toString());
        });
        SocketInstance.on("r", payload -> {
            String event = payload.getNextString();
            this.sendPackets.remove(event);
        });
        this.status = SocketStatus.CONNECTING;
        afkStatus = false;
        this.socket.connect();
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public boolean isConnected() {
        return this.getStatus() == SocketStatus.CONNECTED;
    }

    public static void on(String event, Consumer<SocketEvent> listener) {
        SocketInstance i = SocketInstance.getInstance();
        if (i.socket == null || i.socket.hasListeners(event)) {
            return;
        }
        i.socket.on(event, args -> {
            try {
                listener.accept(new SocketEvent(args));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    public void onIO(String event, Consumer<SocketEvent> listener) {
        if (this.socket.io() == null || this.socket.io().hasListeners(event)) {
            return;
        }
        this.socket.io().on(event, args -> {
            try {
                listener.accept(new SocketEvent(args));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    public void emit(String event, Object ... data) {
        if (!event.equals("r")) {
            this.sendPackets.put(event, data);
        }
        if (this.socket != null) {
            this.socket.emit(event, data);
        }
    }

    public SocketStatus getStatus() {
        return this.status;
    }

    public void setStatus(SocketStatus status) {
        this.status = status;
    }
}

