/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.standardrng;

import com.google.common.collect.Lists;
import com.mcsrranked.client.standardrng.RNGConstant;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3614;
import net.minecraft.class_5138;
import net.minecraft.class_5281;

public class LavaLakeInfo {
    private static final List<class_2382> DIRECTIONS = Lists.newArrayList((Object[])new class_2382[]{new class_2382(0, 0, -1), new class_2382(0, 0, 1), new class_2382(-1, 0, 0), new class_2382(1, 0, 0)});
    private static final double MINIMUM_DISTANCE_BETWEEN_POOLS = 40.0;
    private static final double MAXIMUM_DISTANCE_BLOCKS = 300.0;
    private final class_2338 centerPos;
    private final class_2338 centerFlatPos;
    private final int range;
    private final int lakeRadius;
    private final int count;
    private final long seed;
    private final long populationSeed;
    private final List<class_2382> localDirections;
    private final List<class_2338> placedList = Lists.newCopyOnWriteArrayList();
    private final List<class_2338> confirmList = Lists.newCopyOnWriteArrayList();

    public LavaLakeInfo(class_2338 centerPos, int range, int lakeRadius, int count, long seed) {
        this.centerPos = centerPos;
        this.centerFlatPos = this.centerPos.method_10069(0, -this.centerPos.method_10264(), 0);
        this.range = range;
        this.lakeRadius = lakeRadius;
        this.count = count;
        class_2919 random = new class_2919();
        this.seed = seed;
        this.populationSeed = random.method_12661(seed, this.getCenterPos().method_10263(), this.getCenterPos().method_10260());
        this.localDirections = Lists.newArrayList(DIRECTIONS);
        Collections.shuffle(this.localDirections, (Random)random);
    }

    public class_2338 getCenterPos() {
        return this.centerPos;
    }

    public int getCount() {
        return this.count;
    }

    public int getLakeRadius() {
        return this.lakeRadius;
    }

    public int getRange() {
        return this.range;
    }

    public void generate(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator) {
        int directionOffset = 0;
        Integer centerY = null;
        block0: while (this.placedList.size() < this.getCount() && directionOffset < this.localDirections.size()) {
            class_2382 direction = this.localDirections.get(directionOffset);
            class_2919 random = new class_2919();
            random.method_12664(this.populationSeed, DIRECTIONS.indexOf(direction), 30);
            int modifierX = direction.method_10263();
            int modifierZ = direction.method_10260();
            int distance = this.getRange() + random.nextInt(this.getLakeRadius());
            int offset = random.nextInt(this.getRange() * 2) - this.getRange();
            boolean xOffset = direction.method_10260() != 0;
            class_2338 lakeOffsetPos = this.getCenterPos().method_10069(distance * modifierX + offset * modifierZ, 100, distance * modifierZ + offset * modifierX);
            int chunkOffset = 0;
            int distanceOffset = 0;
            boolean[] offsetChecker = new boolean[]{true, true};
            while (true) {
                boolean shouldGenerate;
                int offsetIndex = chunkOffset <= 0 ? 0 : 1;
                class_2338 targetPos = lakeOffsetPos.method_10069((xOffset ? chunkOffset : distanceOffset) * 16, 0, (!xOffset ? chunkOffset : distanceOffset) * 16);
                class_2338 targetFlatPos = targetPos.method_10069(0, -targetPos.method_10264(), 0);
                if (offsetChecker[offsetIndex] && !this.centerFlatPos.method_19771((class_2382)targetFlatPos, 300.0)) {
                    offsetChecker[offsetIndex] = false;
                }
                if (shouldGenerate = offsetChecker[offsetIndex]) {
                    for (class_2338 blockPos : this.placedList) {
                        if (!blockPos.method_19771((class_2382)targetFlatPos, 40.0)) continue;
                        shouldGenerate = false;
                        break;
                    }
                }
                if (shouldGenerate) {
                    int poolY = this.getSafeYHeight(world, targetPos.method_10263(), targetPos.method_10260());
                    int poolMaxY = 0;
                    for (int i = 1; i < 16; ++i) {
                        poolMaxY = Math.max(poolMaxY, this.getSafeYHeight(world, targetPos.method_10263() + i, targetPos.method_10260() + i));
                    }
                    if (centerY == null) {
                        centerY = world.method_8624(class_2902.class_2903.field_13203, this.centerPos.method_10263(), this.centerPos.method_10260());
                    }
                    class_2919 lakeRandom = new class_2919();
                    lakeRandom.method_12661(this.populationSeed, targetPos.method_10263(), targetPos.method_10260());
                    if (world.method_23753(targetPos).method_8688() == class_1959.class_1961.field_9367) {
                        offsetChecker[offsetIndex] = false;
                    } else if ((centerY > poolY || poolY - centerY < 10) && poolMaxY - poolY <= 6 && class_3031.field_13573.method_13151(world, structureAccessor, chunkGenerator, (Random)lakeRandom, targetPos, (class_3037)RNGConstant.LAVA_FEATURE_CONFIG)) {
                        this.placedList.add(targetFlatPos);
                        this.localDirections.remove(directionOffset);
                        continue block0;
                    }
                }
                if (chunkOffset > 0) {
                    if (chunkOffset > 16) {
                        this.localDirections.remove(directionOffset);
                        continue block0;
                    }
                    chunkOffset = -chunkOffset;
                    continue;
                }
                if (chunkOffset < -4) {
                    if (distanceOffset == 0) {
                        distanceOffset = -1;
                        continue;
                    }
                    if (distanceOffset == -1) {
                        distanceOffset = 1;
                        continue;
                    }
                    chunkOffset = Math.abs(chunkOffset) + 1;
                    continue;
                }
                chunkOffset = Math.abs(chunkOffset) + 1;
            }
        }
    }

    public void checkGenerated(class_5281 worldAccess, class_5138 structureAccessor, class_2794 chunkGenerator) {
        if (this.placedList.size() == this.confirmList.size()) {
            return;
        }
        for (class_2338 blockPos : this.placedList) {
            if (this.confirmList.contains(blockPos)) continue;
            boolean hasLava = false;
            int poolY = worldAccess.method_8624(class_2902.class_2903.field_13203, blockPos.method_10263(), blockPos.method_10260());
            block1: for (int x = 0; x < 16; ++x) {
                for (int y = -8; y <= 0; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        if (worldAccess.method_8320(blockPos.method_10069(x, poolY + y, z)).method_26204() != class_2246.field_10164) continue;
                        hasLava = true;
                        break block1;
                    }
                }
            }
            if (hasLava) {
                this.confirmList.add(blockPos);
                continue;
            }
            class_2919 lakeRandom = new class_2919();
            lakeRandom.method_12661(this.populationSeed, blockPos.method_10263(), blockPos.method_10260());
            class_3031.field_13573.method_13151(worldAccess, structureAccessor, chunkGenerator, (Random)lakeRandom, blockPos.method_10069(0, 100, 0), (class_3037)RNGConstant.LAVA_FEATURE_CONFIG);
        }
    }

    private int getSafeYHeight(class_5281 world, int x, int z) {
        class_2680 state;
        int maxY;
        for (maxY = world.method_24853(); maxY >= 0 && (!(state = world.method_8320(new class_2338(x, maxY, z))).method_26207().method_15801() || state.method_26204() instanceof class_2397 || state.method_26207() == class_3614.field_15932); --maxY) {
        }
        return maxY;
    }

    public LavaLakeInfo copyForReset() {
        LavaLakeInfo newLake = new LavaLakeInfo(this.getCenterPos(), this.getRange(), this.getLakeRadius(), this.getCount(), this.seed);
        newLake.placedList.addAll(this.placedList);
        return newLake;
    }
}

