/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.standardrng;

import com.mcsrranked.client.standardrng.AccessibleRandom;
import com.mcsrranked.client.world.SeedSeparateHelper;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class WorldRNGState
extends class_18 {
    private final long defaultSeed;
    private final HashMap<Integer, AccessibleRandom> randomHashMap = new HashMap();
    private int eyeThrows = 0;

    public static WorldRNGState fromServer(MinecraftServer server) {
        class_3218 serverWorld = server.method_30002();
        WorldRNGState state = (WorldRNGState)serverWorld.method_17983().method_17924(() -> new WorldRNGState(((SeedSeparateHelper)server.method_27728().method_28057()).ss$getRNGSeed()), "rng");
        state.method_80();
        return state;
    }

    public WorldRNGState(long seed) {
        super("rng");
        this.defaultSeed = seed;
        seed += 4262064045L;
        for (Type value : Type.values()) {
            AccessibleRandom random = new AccessibleRandom();
            random.seed.set(AccessibleRandom.initialScramble(seed + (long)value.ordinal()));
            this.randomHashMap.put(value.ordinal(), random);
        }
    }

    public long getDefaultSeed() {
        return this.defaultSeed;
    }

    public class_2487 method_75(class_2487 tag) {
        List seeds = this.randomHashMap.values().stream().map(AccessibleRandom::getSeed).collect(Collectors.toList());
        tag.method_10538("seeds", seeds);
        tag.method_10569("eyeThrows", this.eyeThrows);
        return tag;
    }

    public void method_77(class_2487 tag) {
        long[] seeds = tag.method_10565("seeds");
        for (int i = 0; i < seeds.length; ++i) {
            AccessibleRandom random = new AccessibleRandom();
            random.seed.set(seeds[i]);
            this.randomHashMap.put(i, random);
        }
        if (tag.method_10545("eyeThrows")) {
            this.eyeThrows = tag.method_10550("eyeThrows");
        }
    }

    public AccessibleRandom getRandom(Type type) {
        this.method_80();
        if (!this.randomHashMap.containsKey(type.ordinal())) {
            this.randomHashMap.put(type.ordinal(), new AccessibleRandom());
        }
        return this.randomHashMap.get(type.ordinal());
    }

    public int getEyeThrows() {
        return this.eyeThrows;
    }

    public void addEyeThrows() {
        ++this.eyeThrows;
        this.method_80();
    }

    public static enum Type {
        BLAZE,
        BLAZE_SPAWN,
        MAGMA_CUBE_SPAWN,
        BARTER,
        ENDERMAN,
        FLINT,
        EYE,
        SUS_STEW,
        HOGLIN,
        FOOD_RANDOM,
        TRADE,
        DRAGON_STANDARD,
        DRAGON_PERCH,
        DRAGON_PATH,
        DRAGON_HEIGHT,
        CHICKEN,
        SHEEP,
        SHEEP_SHEARS,
        COW,
        PIG,
        ENDER_MITE,
        RAIN_WITH_THUNDER,
        SPAWN,
        PHANTOM,
        LEAVES,
        DEAD_BUSH,
        FORTRESS_SPAWN,
        BLAZE_SPAWN_COOLDOWN,
        BLAZE_SPAWN_POSITION,
        SKELETON,
        TRIDENT_DROP,
        TRIDENT_DURATION,
        SHULKER,
        VILLAGE_CURING,
        WITHER_SKELETON_L0,
        WITHER_SKELETON_L1,
        WITHER_SKELETON_L2,
        WITHER_SKELETON_L3,
        CAT_TAME,
        WOLF_TAME,
        HORSE_TAME,
        GHAST;

    }
}

