/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.standardrng.mixin;

import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mcsrranked.client.config.RankedGameRules;
import com.mcsrranked.client.standardrng.WorldPortalState;
import com.mcsrranked.client.standardrng.WorldRNGState;
import com.mcsrranked.client.world.GenerationState;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1315;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2919;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3549;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class}, priority=1005)
public abstract class MixinServerPlayerEntity
extends class_1657 {
    @Unique
    private static final Predicate<class_1299<?>> creaturePredicate = entityType -> entityType == class_1299.field_6085 || entityType == class_1299.field_6115 || entityType == class_1299.field_6093 || entityType == class_1299.field_6132;
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Unique
    private int tempSpawnRadius;

    @Shadow
    public abstract class_3218 method_14220();

    public MixinServerPlayerEntity(class_1937 world, class_2338 blockPos, GameProfile gameProfile) {
        super(world, blockPos, gameProfile);
    }

    @ModifyVariable(method={"moveToSpawn"}, at=@At(value="STORE"), ordinal=2)
    public int getSpawnRadius(int i) {
        this.tempSpawnRadius = i;
        return i;
    }

    @ModifyExpressionValue(method={"moveToSpawn"}, at={@At(value="INVOKE", target="Ljava/util/Random;nextInt(I)I")})
    public int onMoveToSpawn(int i) {
        return WorldRNGState.fromServer(this.field_13995).getRandom(WorldRNGState.Type.SPAWN).nextInt(this.tempSpawnRadius);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void onTick(CallbackInfo ci) {
        class_3218 serverWorld = this.method_14220();
        if (serverWorld.method_27983() != class_1937.field_25179) {
            return;
        }
        WorldPortalState portalState = WorldPortalState.fromServer(this.field_13995);
        if (portalState.getSpawnPos() == null) {
            portalState.setSpawnPos((class_2382)this.method_24515());
        }
    }

    @Inject(method={"moveToSpawn"}, at={@At(value="RETURN")})
    public void onSpawn(CallbackInfo ci) {
        class_3218 serverWorld = this.method_14220();
        if (serverWorld.method_27983() != class_1937.field_25179) {
            return;
        }
        GenerationState generateState = (GenerationState)serverWorld.method_17983().method_17924(GenerationState::new, "custom_generated");
        if (generateState.isGenerated()) {
            return;
        }
        generateState.setGenerated(true);
        class_2919 chunkRandom = new class_2919();
        List entities = serverWorld.method_8333((class_1297)this, new class_238(this.method_24515().method_10069(-64, -5, -64), this.method_24515().method_10069(64, 5, 64)), entity -> creaturePredicate.test(entity.method_5864()));
        if (entities.isEmpty()) {
            class_1923 spawnChunk = new class_1923(this.method_24515());
            chunkRandom.method_12661(serverWorld.method_8412(), this.method_24515().method_10263(), this.method_24515().method_10260());
            int tried = 0;
            while (tried++ < 16) {
                int chunkZ;
                int modifier;
                int n = modifier = chunkRandom.nextBoolean() ? 1 : -1;
                int chunkX = spawnChunk.field_9181 + (chunkRandom.nextInt(2) + 1) * modifier;
                class_1923 chunkPos = new class_1923(chunkX, chunkZ = spawnChunk.field_9180 + (chunkRandom.nextInt(2) + 1) * modifier);
                if (!MixinServerPlayerEntity.trySpawnCreatures(serverWorld, chunkPos, (Random)chunkRandom)) continue;
                return;
            }
        }
    }

    @Unique
    private static boolean trySpawnCreatures(class_3218 world, class_1923 chunkPos, Random random) {
        ArrayList list = Lists.newArrayList();
        for (class_1959.class_1964 spawnEntry : world.method_23753(chunkPos.method_8323()).method_8700(class_1311.field_6294)) {
            if (!creaturePredicate.test(spawnEntry.field_9389)) continue;
            list.add(spawnEntry);
        }
        if (class_3549.method_15445((List)list) <= 0) {
            return false;
        }
        class_1959.class_1964 spawnEntry = (class_1959.class_1964)class_3549.method_15446((Random)random, (List)list);
        int spawnSize = spawnEntry.field_9388 + random.nextInt(1 + spawnEntry.field_9387 - spawnEntry.field_9388);
        int spawnEntities = 0;
        class_1315 entityData = null;
        int targetX = chunkPos.method_8326() + random.nextInt(16);
        int targetZ = chunkPos.method_8328() + random.nextInt(16);
        int originalX = targetX;
        int originalZ = targetZ;
        for (int spawnCount = 0; spawnCount < spawnSize; ++spawnCount) {
            boolean spawned = false;
            for (int tried = 0; !spawned && tried < 4; ++tried) {
                class_2338 blockPos = class_1948.method_8658((class_4538)world, (class_1299)spawnEntry.field_9389, (int)targetX, (int)targetZ);
                if (spawnEntry.field_9389.method_5896() && class_1948.method_8660((class_1317.class_1319)class_1317.method_6159((class_1299)spawnEntry.field_9389), (class_4538)world, (class_2338)blockPos, (class_1299)spawnEntry.field_9389)) {
                    class_1308 mobEntity;
                    class_1297 entity;
                    float entityWidth = spawnEntry.field_9389.method_17685();
                    double clampedX = class_3532.method_15363((float)targetX, (float)((float)chunkPos.method_8326() + entityWidth), (float)((float)(chunkPos.method_8326() + 16) - entityWidth));
                    double clampedZ = class_3532.method_15363((float)targetZ, (float)((float)chunkPos.method_8328() + entityWidth), (float)((float)(chunkPos.method_8328() + 16) - entityWidth));
                    if (!world.method_18026(spawnEntry.field_9389.method_17683(clampedX, (double)blockPos.method_10264(), clampedZ)) || !class_1317.method_20638((class_1299)spawnEntry.field_9389, (class_1936)world, (class_3730)class_3730.field_16472, (class_2338)new class_2338(clampedX, (double)blockPos.method_10264(), clampedZ), (Random)world.method_8409())) continue;
                    try {
                        entity = spawnEntry.field_9389.method_5883(world.method_8410());
                    }
                    catch (Exception exception) {
                        field_5955.warn("Failed to create mob", (Throwable)exception);
                        continue;
                    }
                    if (entity == null) continue;
                    entity.method_5808(clampedX, (double)blockPos.method_10264(), clampedZ, random.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof class_1308 && (mobEntity = (class_1308)entity).method_5979((class_1936)world, class_3730.field_16472) && mobEntity.method_5957((class_4538)world)) {
                        entityData = mobEntity.method_5943((class_1936)world, world.method_8404(mobEntity.method_24515()), class_3730.field_16472, entityData, null);
                        world.method_8649((class_1297)mobEntity);
                        spawned = true;
                    }
                }
                targetX += random.nextInt(5) - random.nextInt(5);
                targetZ += random.nextInt(5) - random.nextInt(5);
                while (targetX < chunkPos.method_8326() || targetX >= chunkPos.method_8326() + 16 || targetZ < chunkPos.method_8328() || targetZ >= chunkPos.method_8328() + 16) {
                    targetX = originalX + random.nextInt(5) - random.nextInt(5);
                    targetZ = originalZ + random.nextInt(5) - random.nextInt(5);
                }
            }
            if (!spawned) continue;
            ++spawnEntities;
        }
        return spawnEntities >= 3;
    }

    @Inject(method={"changeDimension"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;removePlayer(Lnet/minecraft/server/network/ServerPlayerEntity;)V", ordinal=1, shift=At.Shift.AFTER)})
    public void onChangeDimension(class_3218 destination, CallbackInfoReturnable<class_1297> cir) {
        if (this.field_6002.method_27983() != class_1937.field_25181) {
            WorldPortalState portalState = WorldPortalState.fromServer(destination.method_8503());
            class_2382 spawnPos = portalState.getSpawnPos();
            if (spawnPos == null) {
                return;
            }
            if (!this.field_13995.method_27728().method_27432().contains("mcsrranked")) {
                return;
            }
            class_1923 currentChunk = new class_1923(this.method_24515());
            class_2382 actualPos = portalState.getActualPos();
            if (this.field_6002.method_27983() == class_1937.field_25179) {
                if (!destination.method_8450().method_8355(RankedGameRules.MODIFIED_PORTAL_BEHAVIORS)) {
                    return;
                }
                if (actualPos == null || class_1923.method_19280((class_1923)new class_1923(new class_2338(actualPos)), (int)9).anyMatch(chunkPos -> chunkPos.equals((Object)currentChunk))) {
                    if (actualPos == null) {
                        portalState.setActualPos((class_2382)this.method_24515());
                    }
                    this.method_5808(spawnPos.method_10263(), 64.0, spawnPos.method_10260(), this.field_6031, this.field_5965);
                }
            } else if (this.field_6002.method_27983() == class_1937.field_25180) {
                class_2382 netherPos = portalState.getNetherPos();
                class_1923 overworldChunk = new class_1923(this.method_24515().method_10263() / 2, this.method_24515().method_10260() / 2);
                if (actualPos != null && netherPos != null && class_1923.method_19280((class_1923)new class_1923(new class_2338(spawnPos)), (int)9).anyMatch(chunkPos -> chunkPos.equals((Object)overworldChunk))) {
                    this.method_5808((float)actualPos.method_10263() / 8.0f, this.method_23318(), (float)actualPos.method_10260() / 8.0f, this.field_6031, this.field_5965);
                }
            }
        }
    }
}

