/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.standardrng.mixin.dragon;

import com.mcsrranked.client.config.RankedGameRules;
import com.mcsrranked.client.standardrng.WorldRNGState;
import com.mcsrranked.client.standardrng.interfaces.EnderDragonPerchTick;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1510;
import net.minecraft.class_1526;
import net.minecraft.class_1527;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1510.class})
public class MixinEnderDragonEntity
extends class_1308
implements EnderDragonPerchTick {
    @Shadow
    @Final
    private class_1526 field_7028;
    @Unique
    private boolean zeroNodeArrived = false;
    @Unique
    private int perchAge = 0;
    @Unique
    private int perchCount = 0;
    @Unique
    private float totalPerchPossibility = 0.0f;
    @Unique
    private float goalPerchPossibility = 0.0f;

    protected MixinEnderDragonEntity(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onInit(class_1299<class_1510> entityType, class_1937 world, CallbackInfo ci) {
        if (!world.method_8608() && world.method_8450().method_8355(RankedGameRules.STANDARDIZED_DRAGON_PERCH)) {
            this.field_5974.setSeed(Objects.requireNonNull(world.method_8503()).method_30002().method_8412() ^ 0xFF5236AA1F106F11L);
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/boss/dragon/phase/Phase;serverTick()V", ordinal=0, shift=At.Shift.BEFORE)})
    public void onTickMoveBefore(CallbackInfo ci) {
        if (this.goalPerchPossibility == 0.0f) {
            this.ranked$perched();
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/boss/dragon/phase/Phase;serverTick()V", ordinal=0, shift=At.Shift.AFTER)})
    public void onTickMove(CallbackInfo ci) {
        class_1527 phaseType = this.field_7028.method_6864().method_6849();
        if (phaseType == class_1527.field_7071) {
            this.ranked$perched();
            return;
        }
        if (phaseType.method_6871() < 2) {
            ++this.perchAge;
        }
    }

    @Override
    public int ranked$getPerchTick() {
        return this.perchAge;
    }

    @Override
    public int ranked$getMaxPerchTick() {
        return 2900;
    }

    @Override
    public void ranked$perched() {
        if (this.field_6002.method_8608()) {
            return;
        }
        if (this.totalPerchPossibility != 0.0f) {
            ++this.perchCount;
        }
        this.perchAge = 0;
        this.totalPerchPossibility = 0.0f;
        float perchAdvance = Math.max(1.0f, (float)this.perchCount / 5.0f) - 1.0f;
        this.goalPerchPossibility = WorldRNGState.fromServer(Objects.requireNonNull(this.method_5682())).getRandom(WorldRNGState.Type.DRAGON_PERCH).nextFloat() * (0.6f + perchAdvance * perchAdvance);
    }

    @Override
    public boolean ranked$isRequireForcePerch() {
        return this.totalPerchPossibility >= this.goalPerchPossibility;
    }

    @Override
    public void ranked$addPerchPossibility(float f) {
        this.totalPerchPossibility += f;
    }

    @Override
    public void ranked$setZeroNodeArrived(boolean b) {
        this.zeroNodeArrived = b;
    }

    @Override
    public boolean ranked$isZeroNodeArrived() {
        return this.zeroNodeArrived;
    }
}

