/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.utils;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.widget.MatchChatWidget;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.race.WeeklyRace;
import com.mcsrranked.client.utils.SSLFixer;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.running.RunType;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1132;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_445;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.ocpsoft.prettytime.PrettyTime;
import org.ocpsoft.prettytime.TimeFormat;
import org.ocpsoft.prettytime.format.SimpleTimeFormat;
import org.ocpsoft.prettytime.units.Day;
import org.ocpsoft.prettytime.units.Hour;
import org.ocpsoft.prettytime.units.JustNow;
import org.ocpsoft.prettytime.units.Minute;
import org.ocpsoft.prettytime.units.Second;

public class ClientUtils {
    private static final HashMap<String, class_3545<Long, JsonElement>> apiResponseCache = Maps.newHashMap();
    private static final PrettyTime DEFAULT_TIME = new PrettyTime(Locale.getDefault()).setUnits(new JustNow(), new Second(), new Minute(), new Hour(), new Day());
    private static final PrettyTime HOUR_DEFAULT_TIME = new PrettyTime(Locale.ENGLISH);

    public static void initTimer(OnlineMatch match, String worldName, long startTime) {
        InGameTimer.start((String)worldName, (RunType)RunType.SET_SEED);
        InGameTimer timer = InGameTimer.getInstance();
        if (match.getStatus().isPlaying() && startTime != 0L) {
            match.setStartTime(startTime);
        }
        match.getOption().getGameMode().onTimerInitialize(timer, match);
    }

    public static void closeScreen() {
        class_310 mcClient = class_310.method_1551();
        if (mcClient.field_1755 instanceof class_445) {
            class_445 creditScreen = (class_445)mcClient.field_1755;
            creditScreen.method_25419();
        } else {
            mcClient.method_1507(null);
        }
    }

    public static void changeSpectate() {
        class_310 mcClient = class_310.method_1551();
        class_1132 server = mcClient.method_1576();
        if (server != null) {
            for (class_3222 serverPlayerEntity : server.method_3760().method_14571()) {
                serverPlayerEntity.method_7336(class_1934.field_9219);
            }
        }
    }

    public static long getSeedFromString(String seedString) {
        try {
            return Long.parseLong(seedString);
        }
        catch (NumberFormatException e) {
            return seedString.hashCode();
        }
    }

    public static void deleteApiResponseCache(String target) {
        apiResponseCache.remove(target);
    }

    @Nullable
    public static JsonElement getApiResponse(String target) {
        try {
            String inputLine;
            URL url;
            HttpURLConnection conn;
            boolean isProdApi;
            boolean bl = isProdApi = !target.startsWith("http");
            if (apiResponseCache.containsKey(target)) {
                if ((Long)apiResponseCache.get(target).method_15442() + 30000L < System.currentTimeMillis()) {
                    apiResponseCache.remove(target);
                } else {
                    return (JsonElement)apiResponseCache.get(target).method_15441();
                }
            }
            if ((conn = (HttpURLConnection)(url = new URL(isProdApi ? MCSRRankedClient.getServerUrl("http") + "/api/" + target : target)).openConnection()) instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(SSLFixer.SOCKET_FACTORY);
            }
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(10000);
            conn.setDoOutput(true);
            if (conn.getResponseCode() != 200) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                sb.append(inputLine);
            }
            br.close();
            JsonElement result = new JsonParser().parse(sb.toString());
            if (isProdApi) {
                result = result.getAsJsonObject().get("data");
            }
            apiResponseCache.put(target, (class_3545<Long, JsonElement>)new class_3545((Object)System.currentTimeMillis(), (Object)result));
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String timeToDurationFormat(long time) {
        Date date = new Date(time);
        return DEFAULT_TIME.formatUnrounded(date);
    }

    public static String timeToHourDurationFormat(long time) {
        Date date = new Date(time);
        return HOUR_DEFAULT_TIME.formatUnrounded(date);
    }

    public static String getDateFormat(Date date, boolean shorten) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(shorten ? 3 : 2, 3, Locale.getDefault());
        String result = dateFormat.format(date);
        return result.replaceAll("\u202f", " ") + " " + TimeZone.getDefault().getDisplayName(false, 0);
    }

    public static String getThousandFormat(int value) {
        if (value < 1000) {
            return String.valueOf(value);
        }
        return value / 1000 + "k";
    }

    public static void playSound(class_3414 soundEvents, float pitch, float volume) {
        class_310 client = class_310.method_1551();
        client.execute(() -> client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundEvents, (float)pitch, (float)volume)));
    }

    public static void playSound(class_3414 soundEvents, class_3419 soundCategory, class_1297 entity, float pitch) {
        ClientUtils.playSound(soundEvents, soundCategory, entity, class_310.method_1551().field_1690.method_1630(soundCategory), pitch);
    }

    public static void playSound(class_3414 soundEvents, class_3419 soundCategory, class_1297 entity, float volume, float pitch) {
        class_310 client = class_310.method_1551();
        client.execute(() -> client.method_1483().method_4873((class_1113)new class_1109(soundEvents, soundCategory, volume, pitch, entity.method_24515())));
    }

    public static void stopSound() {
        class_310 client = class_310.method_1551();
        client.execute(() -> client.method_1483().method_4881());
    }

    public static void addMessage(class_2561 text) {
        class_310 client = class_310.method_1551();
        client.execute(() -> MatchChatWidget.addSystemChat(text, true));
    }

    public static boolean shouldPreGenerateAllDimension() {
        if (MCSRRankedClient.getCurrentRace().map(WeeklyRace::isPlaying).orElse(false).booleanValue()) {
            return true;
        }
        return (Boolean)SpeedRunOption.getOption(RankedOptions.PRE_GENERATE_ALL_DIM) != false && MCSRRankedClient.getOnlineMatch().map(match -> match.getStatus().isPlaying()).orElse(false) != false;
    }

    public static class_1160 vec3dToVector3f(class_243 vec3d) {
        return new class_1160((float)vec3d.method_10216(), (float)vec3d.method_10214(), (float)vec3d.method_10215());
    }

    public static int getUsableSpaceInDrive() {
        return BigInteger.valueOf(MCSRRankedClient.GLOBAL_PATH.toFile().getUsableSpace()).divide(FileUtils.ONE_MB_BI).intValue();
    }

    public static boolean hasEnoughSpaceForReplay() {
        return ClientUtils.getUsableSpaceInDrive() >= 150;
    }

    public static int getUnixTime() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static boolean isAprilFirst() {
        return Calendar.getInstance().get(2) == 3 && Calendar.getInstance().get(5) == 1;
    }

    public static void drawTextWithOutLine(class_327 textRenderer, class_4587 matrixStack, class_2561 text, int x, int y, int color) {
        textRenderer.method_27528(matrixStack, (class_5348)text, (float)x + 1.0f, (float)y + 1.0f, 0);
        textRenderer.method_27528(matrixStack, (class_5348)text, (float)x + 1.0f, (float)y, 0);
        textRenderer.method_27528(matrixStack, (class_5348)text, (float)x + 1.0f, (float)y - 1.0f, 0);
        textRenderer.method_27528(matrixStack, (class_5348)text, (float)x, (float)y - 1.0f, 0);
        textRenderer.method_27528(matrixStack, (class_5348)text, (float)x, (float)y + 1.0f, 0);
        textRenderer.method_27528(matrixStack, (class_5348)text, (float)x - 1.0f, (float)y + 1.0f, 0);
        textRenderer.method_27528(matrixStack, (class_5348)text, (float)x - 1.0f, (float)y, 0);
        textRenderer.method_27528(matrixStack, (class_5348)text, (float)x - 1.0f, (float)y - 1.0f, 0);
        textRenderer.method_27528(matrixStack, (class_5348)text, (float)x, (float)y, color);
    }

    public static long getMaxMemoryMB() {
        return Runtime.getRuntime().maxMemory() / 1024L / 1024L;
    }

    static {
        HOUR_DEFAULT_TIME.clearUnits();
        HOUR_DEFAULT_TIME.registerUnit(new Minute(), (TimeFormat)new SimpleTimeFormat(){
            {
                this.setSingularName("m");
                this.setPluralName("m");
                this.setPattern("%n%u");
                this.setFuturePrefix("");
                this.setFutureSuffix("");
                this.setPastPrefix("");
                this.setPastSuffix("");
            }
        });
        HOUR_DEFAULT_TIME.registerUnit(new Hour(), (TimeFormat)new SimpleTimeFormat(){
            {
                this.setSingularName("h");
                this.setPluralName("h");
                this.setPattern("%n%u");
                this.setFuturePrefix("");
                this.setFutureSuffix("");
                this.setPastPrefix("");
                this.setPastSuffix("");
            }
        });
    }
}

