/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.utils;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.config.RankedOptions;
import com.mojang.datafixers.util.Pair;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import net.minecraft.class_310;

public class CrashReportUtils {
    public static final String MCLO_GS_PRIVACY = "https://aternos.gmbh/en/mclogs/privacy";
    private static final String API_URL = "https://api.mclo.gs/1/log";
    public static File LAST_CRASH_REPORT = null;

    public static void init() {
        File crashReports = new File(class_310.method_1551().field_1697, "crash-reports");
        if (!crashReports.exists() || !crashReports.isDirectory()) {
            return;
        }
        String lastCrashReportName = (String)SpeedRunOption.getOption(RankedOptions.LAST_CRASH_REPORT);
        File[] files = crashReports.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        ArrayList fileList = Lists.newArrayList();
        for (File file : files) {
            try {
                fileList.add(new Pair((Object)file, (Object)Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0])));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        fileList.sort((file1, file2) -> Long.compare(((BasicFileAttributes)file2.getSecond()).creationTime().toMillis(), ((BasicFileAttributes)file1.getSecond()).creationTime().toMillis()));
        String newName = ((File)((Pair)fileList.get(0)).getFirst()).getName();
        SpeedRunOption.setOption(RankedOptions.LAST_CRASH_REPORT, (Object)newName);
        if (!lastCrashReportName.isEmpty() && !lastCrashReportName.equals(newName)) {
            LAST_CRASH_REPORT = (File)((Pair)fileList.get(0)).getFirst();
        }
    }

    public static String getThreadDump() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMxBean.dumpAllThreads(true, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (ThreadInfo threadInfo : threadInfos) {
            stringBuilder.append(threadInfo.toString()).append("\n");
            for (StackTraceElement element : threadInfo.getStackTrace()) {
                stringBuilder.append("\tat ").append(element.toString()).append("\n");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String submitCrash(String raw) {
        block14: {
            String string;
            URL apiUrl = new URL(API_URL);
            HttpURLConnection connection = (HttpURLConnection)apiUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            connection.setDoOutput(true);
            String urlEncodedContent = "content=" + URLEncoder.encode(raw, "UTF-8");
            try (OutputStream os = connection.getOutputStream();){
                os.write(urlEncodedContent.getBytes(StandardCharsets.UTF_8));
                os.flush();
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) break block14;
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            try {
                JsonObject jsonObject = (JsonObject)MCSRRankedClient.GSON.fromJson((Reader)br, JsonObject.class);
                string = jsonObject.get("id").getAsString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            br.close();
            return string;
        }
        return null;
    }
}

