/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.utils;

import java.io.BufferedInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;

public class SSLFixer {
    public static SSLSocketFactory SOCKET_FACTORY;
    public static OkHttpClient OK_HTTP_CLIENT;

    public static void fixer() throws Exception {
        SSLFixer.injectLetsEncryptCerts();
        SSLFixer.fixKeyLength();
    }

    private static void injectLetsEncryptCerts() throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
        keyStore.load(Files.newInputStream(ksPath, new OpenOption[0]), "changeit".toCharArray());
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (BufferedInputStream caInput = new BufferedInputStream(Objects.requireNonNull(SSLFixer.class.getClassLoader().getResourceAsStream("DSTRootCAX3.der")));){
            Certificate crt = cf.generateCertificate(caInput);
            keyStore.setCertificateEntry("DSTRootCAX3", crt);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, tmf.getTrustManagers(), null);
        SOCKET_FACTORY = sslContext.getSocketFactory();
        OK_HTTP_CLIENT = new OkHttpClient.Builder().hostnameVerifier((hostname, session) -> hostname.equals("mcsrranked.com")).sslSocketFactory(SOCKET_FACTORY, (X509TrustManager)tmf.getTrustManagers()[0]).readTimeout(1L, TimeUnit.MINUTES).build();
    }

    public static void fixKeyLength() {
        int newMaxKeyLength;
        if (!System.getProperty("java.runtime.version").startsWith("1.8.0_51")) {
            return;
        }
        String errorString = "Failed manually overriding key-length permissions.";
        try {
            newMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (newMaxKeyLength < 256) {
                Class<?> c = Class.forName("javax.crypto.CryptoAllPermissionCollection");
                Constructor<?> con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                Object allPermissionCollection = con.newInstance(new Object[0]);
                Field f = c.getDeclaredField("all_allowed");
                f.setAccessible(true);
                f.setBoolean(allPermissionCollection, true);
                c = Class.forName("javax.crypto.CryptoPermissions");
                con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                Object allPermissions = con.newInstance(new Object[0]);
                f = c.getDeclaredField("perms");
                f.setAccessible(true);
                ((Map)f.get(allPermissions)).put("*", allPermissionCollection);
                c = Class.forName("javax.crypto.JceSecurityManager");
                f = c.getDeclaredField("defaultPolicy");
                f.setAccessible(true);
                Field mf = Field.class.getDeclaredField("modifiers");
                mf.setAccessible(true);
                mf.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                f.set(null, allPermissions);
                newMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(errorString, e);
        }
        if (newMaxKeyLength < 256) {
            throw new RuntimeException(errorString);
        }
    }
}

