/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.utils.SSLFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.apache.commons.io.FileUtils;

public class UpdateChecker {
    public static void check() {
        String modVersion = MCSRRankedClient.MOD_CONTAINER.getMetadata().getVersion().getFriendlyString();
        for (File file : Objects.requireNonNull(FabricLoader.getInstance().getGameDir().resolve("mods").toFile().listFiles())) {
            String modId = "mcsrranked";
            String fileName = file.getName();
            if (!fileName.startsWith(modId)) continue;
            FileInputStream inputStream = null;
            try {
                inputStream = FileUtils.openInputStream((File)file);
                JsonObject fabricJson = UpdateChecker.getFabricJsonFromInputStream(inputStream);
                inputStream.close();
                if (!VersionPredicate.parse((String)("<" + modVersion)).test((Object)SemanticVersion.parse((String)Objects.requireNonNull(fabricJson).get("version").getAsString()))) continue;
                FileUtils.forceDelete((File)file);
            }
            catch (Throwable e) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                MCSRRankedClient.LOGGER.error("Failed to delete old mod .jar ({}) file!", (Object)fileName);
                e.printStackTrace();
            }
        }
    }

    private static JsonObject getFabricJsonFromInputStream(InputStream inputStream) throws Throwable {
        ZipEntry entry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        JsonElement result = null;
        while ((entry = zipInputStream.getNextEntry()) != null) {
            if (!entry.getName().equals("fabric.mod.json")) continue;
            result = new JsonParser().parse((Reader)new InputStreamReader(zipInputStream));
            zipInputStream.closeEntry();
            break;
        }
        zipInputStream.close();
        return result == null ? null : result.getAsJsonObject();
    }

    public static boolean downloadUrl(String name, String urlString) {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            int responseCode;
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "MCSR-Ranked/" + MCSRRankedClient.MOD_CONTAINER.getMetadata().getVersion() + " (mcsrranked.com)");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(30000);
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(SSLFixer.SOCKET_FACTORY);
            }
            if ((responseCode = conn.getResponseCode()) == 200) {
                int bytesRead;
                is = conn.getInputStream();
                os = new FileOutputStream(FabricLoader.getInstance().getGameDir().resolve("mods").resolve(name).toFile());
                int BUFFER_SIZE = 4096;
                byte[] buffer = new byte[4096];
                while ((bytesRead = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
                os.close();
                is.close();
                MCSRRankedClient.LOGGER.info("File downloaded");
            } else {
                MCSRRankedClient.LOGGER.info("No file to download. Server replied HTTP code: " + responseCode);
            }
            conn.disconnect();
            return responseCode == 200;
        }
        catch (Exception e) {
            MCSRRankedClient.LOGGER.error("An error occurred while trying to download a file.");
            e.printStackTrace();
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
    }
}

