/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.world;

import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.world.WorldCreator;
import java.util.function.Consumer;
import net.minecraft.class_1928;
import net.minecraft.class_1934;

public class WorldCreatorBuilder {
    private final long overworldSeed;
    private final long netherSeed;
    private long theEndSeed;
    private long rngSeed;
    private class_1934 defaultGameMode = null;
    private boolean hardcore = false;
    private boolean allowCommands = false;
    private Runnable beforeReset = () -> {};
    private Runnable beforeLeave = () -> {};
    private boolean spectate = false;
    private WorldCreator.TimerInitializer timerConsumer = (timer, server) -> {};
    private WorldCreator.DataPacksModifier dataPacksModifier = (enabled, disabled) -> {};
    private Consumer<class_1928> gameRulesConsumer = gamerules -> {};
    private int queueCount = 1;
    private int queuePriority = 3;
    private Consumer<WorldCreator> beforeJoin = creator -> {};

    public WorldCreatorBuilder(long overworldSeed, long netherSeed) {
        this.overworldSeed = overworldSeed;
        this.netherSeed = netherSeed;
        this.theEndSeed = this.overworldSeed;
        this.rngSeed = this.overworldSeed;
    }

    public WorldCreatorBuilder(String overworldSeed, String netherSeed) {
        this(ClientUtils.getSeedFromString(overworldSeed), ClientUtils.getSeedFromString(netherSeed));
    }

    public WorldCreatorBuilder setRNGSeed(long rngSeed) {
        this.rngSeed = rngSeed;
        return this;
    }

    public WorldCreatorBuilder setTheEndSeed(long theEndSeed) {
        this.theEndSeed = theEndSeed;
        return this;
    }

    public WorldCreatorBuilder setRNGSeed(String rngSeed) {
        this.setRNGSeed(ClientUtils.getSeedFromString(rngSeed));
        return this;
    }

    public WorldCreatorBuilder setTheEndSeed(String theEndSeed) {
        this.setTheEndSeed(ClientUtils.getSeedFromString(theEndSeed));
        return this;
    }

    public WorldCreatorBuilder setDefaultGameMode(class_1934 defaultGameMode) {
        this.defaultGameMode = defaultGameMode;
        return this;
    }

    public WorldCreatorBuilder setHardcore(boolean hardcore) {
        this.hardcore = hardcore;
        return this;
    }

    public WorldCreatorBuilder setAllowCommands(boolean allowCommands) {
        this.allowCommands = allowCommands;
        return this;
    }

    public WorldCreatorBuilder setBeforeReset(Runnable beforeReset) {
        this.beforeReset = beforeReset;
        return this;
    }

    public WorldCreatorBuilder setBeforeLeave(Runnable beforeLeave) {
        this.beforeLeave = beforeLeave;
        return this;
    }

    public WorldCreatorBuilder addGameRulesConsumer(Consumer<class_1928> gameRulesConsumer) {
        this.gameRulesConsumer = this.gameRulesConsumer.andThen(gameRulesConsumer);
        return this;
    }

    public WorldCreatorBuilder setTimerConsumer(WorldCreator.TimerInitializer timerConsumer) {
        this.timerConsumer = timerConsumer;
        return this;
    }

    public WorldCreatorBuilder setDataPacksModifier(WorldCreator.DataPacksModifier dataPacksModifier) {
        this.dataPacksModifier = dataPacksModifier;
        return this;
    }

    public void setJoinConsumer(Consumer<WorldCreator> beforeJoin) {
        this.beforeJoin = beforeJoin;
    }

    public WorldCreatorBuilder spectate() {
        this.spectate = true;
        this.defaultGameMode = class_1934.field_9219;
        this.allowCommands = true;
        this.addGameRulesConsumer(gameRules -> {
            ((class_1928.class_4312)gameRules.method_20746(class_1928.field_19399)).method_20777("0");
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19406)).method_20758(false, null);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19396)).method_20758(false, null);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19393)).method_20758(false, null);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19392)).method_20758(false, null);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19387)).method_20758(false, null);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19409)).method_20758(false, null);
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19402)).method_20758(true, null);
        });
        this.setQueueSettings(0, 1);
        return this;
    }

    public WorldCreatorBuilder setQueueSettings(int serverQueueCount, int queuePriority) {
        this.queueCount = serverQueueCount;
        this.queuePriority = queuePriority;
        return this;
    }

    public WorldCreator build() {
        return new WorldCreator(this.overworldSeed, this.netherSeed, this.theEndSeed, this.rngSeed, this.queueCount, this.queuePriority, this.spectate, this.defaultGameMode, this.hardcore, this.allowCommands, this.timerConsumer, this.dataPacksModifier, this.beforeReset, this.beforeLeave, this.gameRulesConsumer, this.beforeJoin);
    }
}

