/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.i18n;

import java.util.ListResourceBundle;
import org.ocpsoft.prettytime.Duration;
import org.ocpsoft.prettytime.TimeFormat;
import org.ocpsoft.prettytime.TimeUnit;
import org.ocpsoft.prettytime.impl.TimeFormatProvider;
import org.ocpsoft.prettytime.units.Century;
import org.ocpsoft.prettytime.units.Day;
import org.ocpsoft.prettytime.units.Decade;
import org.ocpsoft.prettytime.units.Hour;
import org.ocpsoft.prettytime.units.JustNow;
import org.ocpsoft.prettytime.units.Millennium;
import org.ocpsoft.prettytime.units.Millisecond;
import org.ocpsoft.prettytime.units.Minute;
import org.ocpsoft.prettytime.units.Month;
import org.ocpsoft.prettytime.units.Second;
import org.ocpsoft.prettytime.units.Week;
import org.ocpsoft.prettytime.units.Year;

public class Resources_uk
extends ListResourceBundle
implements TimeFormatProvider {
    private static final Object[][] OBJECTS = new Object[0][0];
    private static final int tolerance = 50;
    private static final int slavicPluralForms = 3;

    @Override
    public Object[][] getContents() {
        return OBJECTS;
    }

    @Override
    public TimeFormat getFormatFor(TimeUnit t) {
        if (t instanceof JustNow) {
            return new TimeFormat(){

                @Override
                public String format(Duration duration) {
                    return this.performFormat(duration);
                }

                @Override
                public String formatUnrounded(Duration duration) {
                    return this.performFormat(duration);
                }

                private String performFormat(Duration duration) {
                    if (duration.isInFuture()) {
                        return "\u0437\u0430\u0440\u0430\u0437";
                    }
                    if (duration.isInPast()) {
                        return "\u0449\u043e\u0439\u043d\u043e";
                    }
                    return null;
                }

                @Override
                public String decorate(Duration duration, String time) {
                    return time;
                }

                @Override
                public String decorateUnrounded(Duration duration, String time) {
                    return time;
                }
            };
        }
        if (t instanceof Century) {
            return new TimeFormatAided("\u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f", "\u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f", "\u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044c");
        }
        if (t instanceof Day) {
            return new TimeFormatAided("\u0434\u0435\u043d\u044c", "\u0434\u043d\u0456", "\u0434\u043d\u0456\u0432");
        }
        if (t instanceof Decade) {
            return new TimeFormatAided("\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0456\u0442\u0442\u044f", "\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0456\u0442\u0442\u044f", "\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0456\u0442\u044c");
        }
        if (t instanceof Hour) {
            return new TimeFormatAided("\u0433\u043e\u0434\u0438\u043d\u0443", "\u0433\u043e\u0434\u0438\u043d\u0438", "\u0433\u043e\u0434\u0438\u043d");
        }
        if (t instanceof Millennium) {
            return new TimeFormatAided("\u0442\u0438\u0441\u044f\u0447\u043e\u043b\u0456\u0442\u0442\u044f", "\u0442\u0438\u0441\u044f\u0447\u043e\u043b\u0456\u0442\u0442\u044f", "\u0442\u0438\u0441\u044f\u0447\u043e\u043b\u0456\u0442\u044c");
        }
        if (t instanceof Millisecond) {
            return new TimeFormatAided("\u043c\u0456\u043b\u0456\u0441\u0435\u043a\u0443\u043d\u0434\u0443", "\u043c\u0456\u043b\u0456\u0441\u0435\u043a\u0443\u043d\u0434\u0438", "\u043c\u0456\u043b\u0456\u0441\u0435\u043a\u0443\u043d\u0434");
        }
        if (t instanceof Minute) {
            return new TimeFormatAided("\u0445\u0432\u0438\u043b\u0438\u043d\u0443", "\u0445\u0432\u0438\u043b\u0438\u043d\u0438", "\u0445\u0432\u0438\u043b\u0438\u043d");
        }
        if (t instanceof Month) {
            return new TimeFormatAided("\u043c\u0456\u0441\u044f\u0446\u044c", "\u043c\u0456\u0441\u044f\u0446\u0456", "\u043c\u0456\u0441\u044f\u0446\u0456\u0432");
        }
        if (t instanceof Second) {
            return new TimeFormatAided("\u0441\u0435\u043a\u0443\u043d\u0434\u0443", "\u0441\u0435\u043a\u0443\u043d\u0434\u0438", "\u0441\u0435\u043a\u0443\u043d\u0434");
        }
        if (t instanceof Week) {
            return new TimeFormatAided("\u0442\u0438\u0436\u0434\u0435\u043d\u044c", "\u0442\u0438\u0436\u043d\u0456", "\u0442\u0438\u0436\u043d\u0456\u0432");
        }
        if (t instanceof Year) {
            return new TimeFormatAided("\u0440\u0456\u043a", "\u0440\u043e\u043a\u0438", "\u0440\u043e\u043a\u0456\u0432");
        }
        return null;
    }

    private static class TimeFormatAided
    implements TimeFormat {
        private final String[] pluarls;

        public TimeFormatAided(String ... plurals) {
            if (plurals.length != 3) {
                throw new IllegalArgumentException("Wrong plural forms number for slavic language!");
            }
            this.pluarls = plurals;
        }

        @Override
        public String format(Duration duration) {
            long quantity = duration.getQuantityRounded(50);
            StringBuilder result = new StringBuilder();
            result.append(quantity);
            return result.toString();
        }

        @Override
        public String formatUnrounded(Duration duration) {
            long quantity = Math.abs(duration.getQuantity());
            StringBuilder result = new StringBuilder();
            result.append(quantity);
            return result.toString();
        }

        @Override
        public String decorate(Duration duration, String time) {
            return this.performDecoration(duration.isInPast(), duration.isInFuture(), duration.getQuantityRounded(50), time);
        }

        @Override
        public String decorateUnrounded(Duration duration, String time) {
            return this.performDecoration(duration.isInPast(), duration.isInFuture(), Math.abs(duration.getQuantity()), time);
        }

        private String performDecoration(boolean past, boolean future, long n, String time) {
            int pluralIdx;
            int n2 = n % 10L == 1L && n % 100L != 11L ? 0 : (pluralIdx = n % 10L >= 2L && n % 10L <= 4L && (n % 100L < 10L || n % 100L >= 20L) ? 1 : 2);
            if (pluralIdx > 3) {
                throw new IllegalStateException("Wrong plural index was calculated somehow for slavic language");
            }
            StringBuilder result = new StringBuilder();
            if (future) {
                result.append("\u0447\u0435\u0440\u0435\u0437 ");
            }
            result.append(time);
            result.append(' ');
            result.append(this.pluarls[pluralIdx]);
            if (past) {
                result.append(" \u0442\u043e\u043c\u0443");
            }
            return result.toString();
        }
    }
}

