/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes;

public class ColorHelper {
    public static int getAlpha(int argb) {
        return argb >>> 24;
    }

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static int getArgb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int scaleRgb(int argb, float scale) {
        return ColorHelper.getArgb(ColorHelper.getAlpha(argb), ColorHelper.clamp((int)((float)ColorHelper.getRed(argb) * scale)), ColorHelper.clamp((int)((float)ColorHelper.getGreen(argb) * scale)), ColorHelper.clamp((int)((float)ColorHelper.getBlue(argb) * scale)));
    }

    public static int withAlpha(int alpha, int rgb) {
        return alpha << 24 | rgb & 0xFFFFFF;
    }

    private static int clamp(int value) {
        return Math.min(255, Math.max(value, 0));
    }
}

