/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes.emoticon;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import xeed.mc.streamotes.Compat;
import xeed.mc.streamotes.ImageHandler;
import xeed.mc.streamotes.InternalMethods;
import xeed.mc.streamotes.Streamotes;
import xeed.mc.streamotes.api.IEmoticonLoader;
import xeed.mc.streamotes.emoticon.AsyncEmoticonLoader;

public class Emoticon
implements Closeable {
    private final IEmoticonLoader loader;
    public final int priority;
    private final String code;
    private final String codeLower;
    private final String source;
    private final boolean zeroWidth;
    private final Compat.Texture texture;
    private Object identifier;
    private class_2561 tooltip;
    private class_2561 preview;
    private boolean loadRequested;
    private int width;
    private int height;
    private class_1011 loadBuffer;
    private BufferedImage tempBuffer;
    private int[] frameTimes;
    private int spriteSheetWidth;
    private int spriteSheetHeight;
    private long animationTime;
    private int currentFrameTime;
    private int currentFrame;
    private int currentFrameTexCoordX;
    private int currentFrameTexCoordY;
    private long lastRenderTime;

    public Emoticon(String source, String code, boolean zeroWidth, int priority, IEmoticonLoader loader) {
        this.source = source;
        this.code = code;
        this.zeroWidth = zeroWidth;
        this.priority = priority;
        this.loader = loader;
        this.codeLower = code.toLowerCase(Locale.ROOT);
        this.tooltip = class_2561.method_43470((String)code);
        this.texture = new Compat.Texture();
    }

    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.code;
    }

    public class_2561 getPreview() {
        return this.preview;
    }

    public String getNameLower() {
        return this.codeLower;
    }

    public Object getLoadData() {
        return this.identifier;
    }

    public void setLoadData(Object loadData) {
        this.identifier = loadData;
    }

    public void setTooltip(String extraInfo) {
        this.tooltip = class_2561.method_43470((String)(this.code + "\n")).method_10852((class_2561)class_2561.method_43470((String)extraInfo).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
        this.preview = class_2561.method_43470((String)this.code).method_10862(Compat.makeEmoteStyle(this)).method_27693(" " + String.valueOf(class_2561.method_43470((String)extraInfo).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)))));
    }

    public IEmoticonLoader getLoader() {
        return this.loader;
    }

    public void writeImage(File destination) throws IOException {
        ImageIO.write((RenderedImage)this.tempBuffer, "png", destination);
    }

    public void setImage(BufferedImage image) throws IOException {
        this.currentFrameTexCoordX = 0;
        this.currentFrameTexCoordY = 0;
        this.frameTimes = null;
        this.spriteSheetWidth = image.getWidth();
        this.spriteSheetHeight = image.getHeight();
        this.width = this.spriteSheetWidth;
        this.height = this.spriteSheetHeight;
        this.tempBuffer = image;
        this.loadBuffer = InternalMethods.awtToNative(image);
    }

    public void setFrameData(int[] frameTimes, int spriteWidth, int spriteHeight) {
        this.currentFrameTexCoordX = 0;
        this.currentFrameTexCoordY = 0;
        this.frameTimes = frameTimes;
        this.width = spriteWidth;
        this.height = spriteHeight;
    }

    public void setImages(BufferedImage[] images, int[] frameTimes) throws IOException {
        this.currentFrameTexCoordX = 0;
        this.currentFrameTexCoordY = 0;
        this.frameTimes = frameTimes;
        this.width = images[0].getWidth();
        this.height = images[0].getHeight();
        int framesPerX = class_3532.method_15386((float)class_3532.method_15355((float)images.length));
        int framesPerY = class_3532.method_15386((float)((float)images.length / (float)framesPerX));
        this.spriteSheetWidth = this.width * framesPerX;
        this.spriteSheetHeight = this.height * framesPerY;
        this.tempBuffer = new BufferedImage(this.spriteSheetWidth, this.spriteSheetHeight, 2);
        DrawImageCallback callback = new DrawImageCallback();
        Graphics2D g = this.tempBuffer.createGraphics();
        for (int y = 0; y < framesPerY; ++y) {
            int frameIdx;
            for (int x = 0; x < framesPerX && (frameIdx = x + y * framesPerX) < images.length; ++x) {
                callback.prepare();
                if (g.drawImage(images[frameIdx], x * this.width, y * this.height, ImageHandler.TRANSPARENT, callback)) continue;
                while (!callback.isReady()) {
                    Streamotes.sleepSweetPrince(5);
                }
            }
        }
        this.loadBuffer = InternalMethods.awtToNative(this.tempBuffer);
    }

    public Compat.Texture getTexture() {
        if (this.loadBuffer != null) {
            this.texture.upload("Emote " + this.code, this.loadBuffer);
            this.loadBuffer.close();
            this.loadBuffer = null;
            this.loadRequested = false;
        }
        return this.texture;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getFrameTimes() {
        return this.frameTimes;
    }

    public float getChatRenderWidth() {
        if (this.zeroWidth) {
            return 0.0f;
        }
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1772);
        float height = (float)(9.0 + (Double)client.field_1690.method_42546().method_41753() * 8.0);
        return this.getRenderWidth(height);
    }

    public float getRenderWidth(float renderHeight) {
        return this.height == 0 ? 0.0f : renderHeight * (float)this.width / (float)this.height;
    }

    public void requestTexture() {
        if (!this.loadRequested) {
            this.loadRequested = true;
            Streamotes.log("Requesting load of " + this.getName());
            AsyncEmoticonLoader.instance.loadAsync(this);
        }
    }

    @Override
    public void close() {
        if (this.loadBuffer != null) {
            this.loadBuffer.close();
            this.loadBuffer = null;
        }
        this.texture.close();
    }

    public class_2561 getTooltip() {
        return this.tooltip;
    }

    public boolean isAnimated() {
        return this.frameTimes != null;
    }

    public void discardBitmap() {
        this.tempBuffer = null;
    }

    public void updateAnimation() {
        long now = System.currentTimeMillis();
        if (this.lastRenderTime == 0L) {
            this.lastRenderTime = now;
            this.currentFrameTime = this.frameTimes[0];
        }
        this.animationTime += now - this.lastRenderTime;
        int lastFrame = this.currentFrame;
        while (this.animationTime > (long)this.currentFrameTime) {
            this.animationTime -= (long)this.currentFrameTime;
            if (++this.currentFrame >= this.frameTimes.length) {
                this.currentFrame = 0;
            }
            this.currentFrameTime = this.frameTimes[this.currentFrame];
        }
        if (this.currentFrame != lastFrame) {
            this.currentFrameTexCoordX = this.currentFrame * this.width % this.spriteSheetWidth;
            this.currentFrameTexCoordY = this.currentFrame * this.width / this.spriteSheetWidth * this.height;
        }
        this.lastRenderTime = now;
    }

    public int getCurrentFrameTexCoordX() {
        return this.currentFrameTexCoordX;
    }

    public int getCurrentFrameTexCoordY() {
        return this.currentFrameTexCoordY;
    }

    public int getSheetWidth() {
        return this.spriteSheetWidth;
    }

    public int getSheetHeight() {
        return this.spriteSheetHeight;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Emoticon)) return false;
        Emoticon other = (Emoticon)obj;
        if (!this.code.equals(other.code)) return false;
        return true;
    }

    private static class DrawImageCallback
    implements ImageObserver {
        private boolean isReady;

        private DrawImageCallback() {
        }

        public void prepare() {
            this.isReady = false;
        }

        @Override
        public boolean imageUpdate(Image img, int infoFlags, int x, int y, int width, int height) {
            if ((infoFlags & 0x20) == 32) {
                this.isReady = true;
            } else if ((infoFlags & 0x80) == 128) {
                this.isReady = true;
            }
            return false;
        }

        public boolean isReady() {
            return this.isReady;
        }
    }
}

