/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes.addon.pack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import xeed.mc.streamotes.addon.TwitchEmotesAPI;
import xeed.mc.streamotes.api.EmoteLoaderException;
import xeed.mc.streamotes.emoticon.Emoticon;
import xeed.mc.streamotes.emoticon.EmoticonRegistry;

public class TwitchGlobalPack {
    private static final String EMOTE_URL_TEMPLATE = "https://static-cdn.jtvnw.net/emoticons/v2/{{id}}/default/dark/2.0";
    private static final int PRIO = 1;

    private static void loadSource1() throws IOException {
        URL apiURL = TwitchEmotesAPI.getURL("https://twitchemotes.com/");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(TwitchEmotesAPI.openStream(apiURL)));){
            TwitchEmotesAPI.concentrateLines(reader, line -> {
                int beginAt = 0;
                while (beginAt < line.length()) {
                    String prefix = "data-regex=\"";
                    int ixStart = line.indexOf(prefix, beginAt);
                    if (ixStart == -1) {
                        return;
                    }
                    int ixEnd = line.indexOf("\"", ixStart + prefix.length());
                    if (ixEnd == -1) {
                        return;
                    }
                    String code = line.substring(ixStart + prefix.length(), ixEnd);
                    prefix = "data-image-id=\"";
                    ixStart = line.indexOf(prefix);
                    if (ixStart == -1) {
                        return;
                    }
                    ixEnd = line.indexOf("\"", ixStart + prefix.length());
                    if (ixEnd == -1) {
                        return;
                    }
                    String id = line.substring(ixStart + prefix.length(), ixEnd);
                    Emoticon emoticon = EmoticonRegistry.registerEmoticon(".Twitch", code, 1, TwitchGlobalPack::loadEmoticonImage);
                    if (emoticon != null) {
                        emoticon.setLoadData(id);
                        emoticon.setTooltip("Twitch");
                    }
                    beginAt = ixEnd + 1;
                }
            });
        }
    }

    private static void loadSource2() throws IOException {
        URL apiURL = TwitchEmotesAPI.getURL("https://www.twitchmetrics.net/emotes/");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(TwitchEmotesAPI.openStream(apiURL)));){
            TwitchEmotesAPI.concentrateLines(reader, line -> {
                int beginAt = 0;
                while (beginAt < line.length()) {
                    String prefix = "<a href=\"/e/";
                    int ixStart = line.indexOf("<a href=\"/e/", beginAt);
                    if (ixStart == -1) {
                        return;
                    }
                    int ixEnd = line.indexOf("\"", ixStart + "<a href=\"/e/".length());
                    if (ixEnd == -1) {
                        return;
                    }
                    String idCode = line.substring(ixStart + "<a href=\"/e/".length(), ixEnd);
                    if ((ixStart = idCode.indexOf(45)) == -1) {
                        return;
                    }
                    String id = idCode.substring(0, ixStart);
                    String code = idCode.substring(ixStart + 1);
                    Emoticon emoticon = EmoticonRegistry.registerEmoticon(".Twitch", code, 1, TwitchGlobalPack::loadEmoticonImage);
                    if (emoticon != null) {
                        emoticon.setLoadData(id);
                        emoticon.setTooltip("Twitch");
                    }
                    beginAt = ixEnd + 1;
                }
            });
        }
    }

    public static void loadMetadata() {
        try {
            TwitchGlobalPack.loadSource1();
        }
        catch (IOException ignored) {
            try {
                TwitchGlobalPack.loadSource2();
            }
            catch (Exception e) {
                throw new EmoteLoaderException("Unhandled exception", e);
            }
        }
    }

    private static void loadEmoticonImage(Emoticon emoticon) {
        String data = (String)emoticon.getLoadData();
        try {
            TwitchEmotesAPI.loadEmoteImage(emoticon, new URI(EMOTE_URL_TEMPLATE.replace("{{id}}", data)), "twitch", data);
        }
        catch (URISyntaxException e) {
            throw new EmoteLoaderException(e);
        }
    }
}

