/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes.addon.pack;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import xeed.mc.streamotes.addon.TwitchEmotesAPI;
import xeed.mc.streamotes.api.EmoteLoaderException;
import xeed.mc.streamotes.emoticon.Emoticon;
import xeed.mc.streamotes.emoticon.EmoticonRegistry;

public class X7tvPack {
    private static final String URL_TEMPLATE = "https://cdn.7tv.app/emote/{{id}}/2x.webp";
    private static final int PRIO = 7;
    static final int FLAG_ZERO_WIDTH = 256;
    static final int FLAG_NSFW = 65536;
    static final int FLAG_EPILEPSY = 131072;
    static final int FLAG_EDGY = 262144;

    public static void loadMetadata() {
        try {
            URL apiURL = TwitchEmotesAPI.getURL("https://7tv.io/v3/emote-sets/global");
            JsonArray emotes = TwitchEmotesAPI.getJsonObj(apiURL).get("emotes").getAsJsonArray();
            for (int i = 0; i < emotes.size(); ++i) {
                int flags;
                boolean zeroWidth;
                JsonObject entry = emotes.get(i).getAsJsonObject();
                String code = TwitchEmotesAPI.getJsonString(entry, "name");
                Emoticon emoticon = EmoticonRegistry.registerEmoticon(".7tv", code, zeroWidth = ((flags = entry.getAsJsonObject("data").get("flags").getAsInt()) & 0x100) != 0, 7, X7tvPack::loadEmoticonImage);
                if (emoticon == null) continue;
                emoticon.setLoadData(TwitchEmotesAPI.getJsonString(entry, "id"));
                emoticon.setTooltip("7tv");
            }
        }
        catch (FileNotFoundException apiURL) {
        }
        catch (Exception e) {
            throw new EmoteLoaderException("Unhandled exception", e);
        }
    }

    private static void loadEmoticonImage(Emoticon emoticon) {
        String data = (String)emoticon.getLoadData();
        try {
            TwitchEmotesAPI.loadEmoteImage(emoticon, new URI(URL_TEMPLATE.replace("{{id}}", data)), "7tv", data);
        }
        catch (URISyntaxException e) {
            throw new EmoteLoaderException(e);
        }
    }
}

