/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.data.gen;

import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import tv.mapper.mapperbase.world.level.block.BaseBlocks;
import tv.mapper.mapperbase.world.level.block.SlopeBlock;
import tv.mapper.mapperbase.world.level.block.UpDownBlock;

public class BaseBlockStates
extends BlockStateProvider {
    protected final String mod_id;

    public BaseBlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), modid, exFileHelper);
        this.mod_id = modid;
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)BaseBlocks.STEEL_BLOCK.get());
        this.slabBlock((SlabBlock)BaseBlocks.STEEL_SLAB.get(), this.modLoc("block/steel_block"), this.modLoc("block/steel_slab_side"), this.modLoc("block/steel_block"), this.modLoc("block/steel_block"));
        this.stairsBlock((StairBlock)BaseBlocks.STEEL_STAIRS.get(), this.modLoc("block/steel_block"), this.modLoc("block/steel_block"), this.modLoc("block/steel_block"));
        this.newWallBlock((WallBlock)BaseBlocks.STEEL_WALL.get(), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/steel_wall_post"), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/steel_wall_side"), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/steel_wall_side_tall"));
        this.pressurePlateBlock((PressurePlateBlock)BaseBlocks.STEEL_PRESSURE_PLATE.get(), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/steel_pressure_plate"), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/steel_pressure_plate_down"));
        this.fenceBlock((FenceBlock)BaseBlocks.STEEL_FENCE.get(), this.modLoc("block/steel_block"));
        this.fenceGateBlock((FenceGateBlock)BaseBlocks.STEEL_FENCE_GATE.get(), this.modLoc("block/steel_block"));
    }

    protected void pressurePlateBlock(Block block, ModelFile plate, ModelFile plate_down) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(plate_down).addModel()).partialState().with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(plate).addModel();
    }

    protected void upDownBlock(Block block, ModelFile model) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)UpDownBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(model).rotationX(180).addModel()).partialState().with((Property)UpDownBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).addModel();
    }

    protected void allRotationBlock(Block block, ModelFile model) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP).modelForState().modelFile(model).rotationX(270).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN).modelForState().modelFile(model).rotationX(90).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH).modelForState().modelFile(model).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH).modelForState().modelFile(model).rotationY(180).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST).modelForState().modelFile(model).rotationY(90).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST).modelForState().modelFile(model).rotationY(270).uvLock(true).addModel();
    }

    protected void buttonBlock(Block block, ModelFile model, ModelFile pressed, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            AttachFace face = (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_);
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            Boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
            return ConfiguredModel.builder().modelFile(powered != false ? pressed : model).rotationX(face == AttachFace.WALL ? 90 : (face == AttachFace.CEILING ? 180 : 0)).rotationY(((int)dir.m_122435_() + angleOffset) % 360).uvLock(face == AttachFace.WALL).build();
        });
    }

    protected void orientableBlock(Block block, ModelFile model, int angleOffset) {
        this.orientableBlock(block, (BlockState $) -> model, angleOffset);
    }

    protected void orientableBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + angleOffset) % 360).build(), new Property[]{BlockStateProperties.f_61362_});
    }

    protected void rooftilesStairsBlock(StairBlock block, ResourceLocation texture) {
        String baseName = block.m_7705_();
        ModelBuilder stairs = this.models().stairs(baseName, texture, texture, texture);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", texture, texture, texture);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", texture, texture, texture);
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> BaseBlockStates.lambda$rooftilesStairsBlock$3((ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter, arg_0), new Property[]{StairBlock.f_56844_});
    }

    protected void newWallBlock(WallBlock block, ModelFile post, ModelFile side, ModelFile side_tall) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).addModel()).condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).addModel()).condition((Property)WallBlock.f_57951_, (Comparable[])new WallSide[]{WallSide.LOW}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(90).uvLock(true).addModel()).condition((Property)WallBlock.f_57950_, (Comparable[])new WallSide[]{WallSide.LOW}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(180).uvLock(true).addModel()).condition((Property)WallBlock.f_57952_, (Comparable[])new WallSide[]{WallSide.LOW}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(270).uvLock(true).addModel()).condition((Property)WallBlock.f_57953_, (Comparable[])new WallSide[]{WallSide.LOW}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side_tall).addModel()).condition((Property)WallBlock.f_57951_, (Comparable[])new WallSide[]{WallSide.TALL}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side_tall).rotationY(90).uvLock(true).addModel()).condition((Property)WallBlock.f_57950_, (Comparable[])new WallSide[]{WallSide.TALL}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side_tall).rotationY(180).uvLock(true).addModel()).condition((Property)WallBlock.f_57952_, (Comparable[])new WallSide[]{WallSide.TALL}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side_tall).rotationY(270).uvLock(true).addModel()).condition((Property)WallBlock.f_57953_, (Comparable[])new WallSide[]{WallSide.TALL}).end();
    }

    protected void slopeBlock(Block block, String name, String modid) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        Object modelName = "";
        for (int i = 1; i < 9; ++i) {
            modelName = i == 8 ? modid + ":block/" + name : modid + ":block/" + name + "_slope_" + i * 2;
            builder.partialState().with((Property)SlopeBlock.LAYERS, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile((String)modelName)).addModel();
        }
    }

    protected void slopeBlock(Block block, String name, String modid, Block fullBlock) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        Object modelName = "";
        for (int i = 1; i < 9; ++i) {
            modelName = i == 8 ? fullBlock.m_7705_() + ":block/" + fullBlock.m_7705_() : modid + ":block/" + name + "_slope_" + i * 2;
            builder.partialState().with((Property)SlopeBlock.LAYERS, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile((String)modelName)).addModel();
        }
    }

    protected String getModId() {
        return this.mod_id;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$rooftilesStairsBlock$3(ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        int yRot = (int)facing.m_122427_().m_122435_();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
            yRot += 270;
        }
        if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
            yRot += 90;
        }
        return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot %= 360).uvLock(false).build();
    }
}

