/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.data.gen;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import tv.mapper.mapperbase.world.level.block.CustomDoorBlock;

public abstract class BaseLootTableProvider
extends VanillaBlockLoot {
    private final String modid;
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private static final Set<Item> IMMUNE_TO_EXPLOSIONS = (Set)Stream.of(Blocks.f_50260_, Blocks.f_50273_, Blocks.f_50569_, Blocks.f_50310_, Blocks.f_50312_, Blocks.f_50316_, Blocks.f_50314_, Blocks.f_50318_, Blocks.f_50320_, Blocks.f_50456_, Blocks.f_50525_, Blocks.f_50521_, Blocks.f_50522_, Blocks.f_50466_, Blocks.f_50464_, Blocks.f_50523_, Blocks.f_50460_, Blocks.f_50465_, Blocks.f_50462_, Blocks.f_50459_, Blocks.f_50458_, Blocks.f_50463_, Blocks.f_50520_, Blocks.f_50524_, Blocks.f_50457_, Blocks.f_50461_).map(ItemLike::m_5456_).collect(ImmutableSet.toImmutableSet());
    private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));

    protected abstract void addTables();

    public BaseLootTableProvider(String modid) {
        this.modid = modid;
    }

    protected static <T extends FunctionUserBuilder<T>> T withExplosionDecay(ItemLike p_218552_0_, FunctionUserBuilder<T> p_218552_1_) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(p_218552_0_.m_5456_()) ? p_218552_1_.m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()) : p_218552_1_.m_79073_());
    }

    protected static <T extends ConditionUserBuilder<T>> T withSurvivesExplosion(ItemLike p_218560_0_, ConditionUserBuilder<T> p_218560_1_) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(p_218560_0_.m_5456_()) ? p_218560_1_.m_79080_(ExplosionCondition.m_81661_()) : p_218560_1_.m_79073_());
    }

    protected LootTable.Builder createStandardTable(String modid, Block block) {
        String name = block.m_7705_().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSlabTable(String modid, Block block) {
        String name = block.m_7705_().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BaseLootTableProvider.withExplosionDecay((ItemLike)block, LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createDoorTable(String modid, Block block) {
        String name = block.m_7705_().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)CustomDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)))).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createBedTable(String modid, Block block) {
        String name = block.m_7705_().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD)))).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createChestTable(String name, Block block) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY))).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSilkTable(String modid, Block block, Block loot) {
        String name = block.m_7705_().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)BaseLootTableProvider.withSurvivesExplosion((ItemLike)block, LootItem.m_79579_((ItemLike)loot))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSilkTable(String modid, Block block, Item loot) {
        String name = block.m_7705_().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)BaseLootTableProvider.withSurvivesExplosion((ItemLike)block, LootItem.m_79579_((ItemLike)loot))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSilkTable(String modid, Block block, Item loot, int min, int max, int fortune) {
        String name = block.m_7705_().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)BaseLootTableProvider.withSurvivesExplosion((ItemLike)block, LootItem.m_79579_((ItemLike)loot).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)fortune)))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected void m_245660_() {
        this.addTables();
    }

    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getEntries().stream().filter(e -> ((ResourceKey)e.getKey()).m_135782_().m_135827_().equals(this.modid)).map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

