/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.enchantery;

import com.ordana.enchantery.access.EnchantmentTableBlockEntityAccess;
import com.ordana.enchantery.configs.CommonConfigs;
import com.ordana.enchantery.reg.ModEnchants;
import com.ordana.enchantery.reg.ModParticles;
import com.ordana.enchantery.reg.ModTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnchanteryLogic {
    private static final List<Enchantment> CURSES = new ArrayList<Enchantment>();

    public static void leechingCurseLogic(Level level, Entity entity, int inventorySlot) {
        ItemStack stack = entity.m_141942_(inventorySlot).m_142196_();
        int f = EnchantmentHelper.m_44843_((Enchantment)ModEnchants.LEECHING_CURSE.get(), (ItemStack)stack);
        if (level.m_5776_()) {
            return;
        }
        if (f > 0 && level.f_46441_.m_188503_(100 / f) == 0) {
            int currentDam = stack.m_41773_();
            int maxDam = stack.m_41776_();
            if (currentDam > 0) {
                if (currentDam <= maxDam - f * 2) {
                    stack.m_41721_(currentDam - f * 2);
                } else {
                    stack.m_41721_(0);
                }
                entity.m_6469_(level.m_269111_().m_269425_(), (float)f);
            }
        }
    }

    public static void butterfingersCurseLogic(Entity entity, ItemStack stack) {
        Level level = entity.f_19853_;
        int f = EnchantmentHelper.m_44843_((Enchantment)ModEnchants.BUTTERFINGER_CURSE.get(), (ItemStack)stack);
        if (level.m_5776_()) {
            return;
        }
        if (level.f_46441_.m_188503_(4) < f && f > 0 && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_182294_(true);
            player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, player.m_150109_().f_35977_, ItemStack.f_41583_));
        }
    }

    public static boolean devouringCurseLogic(Player player, BlockState state, ItemStack stack) {
        int f = EnchantmentHelper.m_44843_((Enchantment)ModEnchants.DEVOURING_CURSE.get(), (ItemStack)stack);
        if (f > 0 && player.f_19853_.f_46441_.m_188503_(f + 1) > 0) {
            int currentDam = stack.m_41773_();
            if (currentDam > 0) {
                stack.m_41721_(currentDam - f / 2);
            }
            player.m_36246_(Stats.f_12949_.m_12902_((Object)state.m_60734_()));
            player.m_36399_(0.005f);
            return true;
        }
        return false;
    }

    public static float imprecisionCurseLogic(ItemStack stack) {
        int f = EnchantmentHelper.m_44843_((Enchantment)ModEnchants.IMPRECISION_CURSE.get(), (ItemStack)stack);
        return f * 2;
    }

    public static void kickbackCurseLogic(LivingEntity entity, ItemStack stack) {
        int f = EnchantmentHelper.m_44843_((Enchantment)ModEnchants.KICKBACK_CURSE.get(), (ItemStack)stack);
        if (f > 0) {
            Vec3 vec = entity.m_20252_(1.0f);
            entity.m_147240_((double)f, vec.f_82479_, vec.f_82481_);
        }
    }

    public static void soulboundLogic(IDropItemOnDeathEvent event) {
        ItemStack stack = event.getItemStack();
        int f = EnchantmentHelper.m_44843_((Enchantment)ModEnchants.SOULBOUND.get(), (ItemStack)stack);
        if (f > 0) {
            if (event.isBeforeDrop()) {
                int maxDam = stack.m_41776_();
                int currentDam = stack.m_41773_();
                int dam = maxDam - (maxDam - currentDam) / 2;
                stack.m_41721_(dam - 1);
            }
            event.setCanceled(true);
        }
    }

    public static void modifyEnchantmentList(ContainerLevelAccess access, RandomSource random, ItemStack stack, List<EnchantmentInstance> list, int enchLevel) {
        AtomicInteger malus = new AtomicInteger();
        AtomicInteger stabilizers = new AtomicInteger();
        HashMap enchants = new HashMap();
        access.m_39292_((level, blockPos) -> {
            for (BlockPos offset : EnchantmentTableBlock.f_207902_) {
                BlockPos target = offset.m_121955_((Vec3i)blockPos);
                BlockState targetState = level.m_8055_(target);
                if (targetState.m_204336_(ModTags.CURSE_AUGMENTS)) {
                    malus.set(malus.get() + 1);
                    continue;
                }
                if (targetState.m_204336_(ModTags.ENCHANTMENT_STABILIZERS)) {
                    if (targetState.m_60734_() instanceof CandleBlock && ((Boolean)targetState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                        stabilizers.getAndAdd((Integer)targetState.m_61143_((Property)BlockStateProperties.f_155994_));
                        continue;
                    }
                    stabilizers.getAndAdd(4);
                    continue;
                }
                BlockEntity patt6316$temp = level.m_7702_(target);
                if (!(patt6316$temp instanceof Container)) continue;
                Container container = (Container)patt6316$temp;
                if (!targetState.m_204336_(ModTags.VALID_BOOK_SOURCE)) continue;
                for (int j = 0; j < container.m_6643_(); ++j) {
                    if (!container.m_8020_(j).m_150930_(Items.f_42690_)) continue;
                    Map enchList = EnchantmentHelper.m_44831_((ItemStack)container.m_8020_(j));
                    enchList.forEach((e, v) -> enchants.merge(e, v, Math::max));
                }
            }
        });
        ArrayList<EnchantmentInstance> bookEnchants = new ArrayList<EnchantmentInstance>();
        for (Map.Entry e2 : enchants.entrySet()) {
            Enchantment en = (Enchantment)e2.getKey();
            Holder<Enchantment> holder = EnchanteryLogic.getHolder(en);
            if (!en.f_44672_.m_7454_(stack.m_41720_()) || holder.m_203656_(ModTags.EXEMPT) || holder.m_203656_(ModTags.BASIC)) continue;
            int enchValue = random.m_188503_(((Integer)e2.getValue()).intValue()) + stabilizers.get() / 4;
            bookEnchants.add(new EnchantmentInstance(en, Math.min(enchValue + 1, ((Enchantment)e2.getKey()).m_6586_())));
        }
        for (int j = 0; j < enchLevel + 1 + CommonConfigs.ENCHANT_COUNT_BOOST.get() && !bookEnchants.isEmpty(); ++j) {
            int listIndex = random.m_188503_(bookEnchants.size());
            list.add((EnchantmentInstance)bookEnchants.get(listIndex));
            bookEnchants.remove(listIndex);
        }
        int curses = malus.get() / 4;
        for (int i = 0; i < curses; ++i) {
            Enchantment curse = CURSES.get(random.m_188503_(CURSES.size()));
            if (!curse.f_44672_.m_7454_(stack.m_41720_())) continue;
            list.add(new EnchantmentInstance(curse, 1));
        }
        if (random.m_188503_(16) < stabilizers.get()) {
            list.removeIf(e -> e.f_44947_.m_6589_());
        }
    }

    public static void setup() {
        for (Enchantment v : BuiltInRegistries.f_256876_) {
            if (!v.m_6589_()) continue;
            CURSES.add(v);
        }
    }

    public static EnchantmentInfluencer getInfluenceType(Level level, BlockPos blockPos, BlockPos blockPos2) {
        BlockState state = level.m_8055_(blockPos.m_121955_((Vec3i)blockPos2));
        EnchantmentInfluencer i = EnchantmentInfluencer.get(state);
        if (i != null && level.m_46859_(blockPos.m_7918_(blockPos2.m_123341_() / 2, blockPos2.m_123342_(), blockPos2.m_123343_() / 2))) {
            return i;
        }
        return null;
    }

    public static Holder<Enchantment> getHolder(Enchantment enchantment) {
        return (Holder)BuiltInRegistries.f_256876_.m_203300_(BuiltInRegistries.f_256876_.m_7447_((Object)enchantment)).get();
    }

    public static int getCharge(Level level, BlockPos pos) {
        if (level.m_7702_(pos) instanceof EnchantmentTableBlockEntity) {
            return ((EnchantmentTableBlockEntityAccess)level.m_7702_(pos)).getCharge();
        }
        return 0;
    }

    public static enum EnchantmentInfluencer {
        CURSE_AGUMENT((SimpleParticleType)ModParticles.CURSE_PARTICLE.get()),
        STABILIZER((SimpleParticleType)ModParticles.STABILIZER_PARTICLE.get());

        public final SimpleParticleType particle;

        private EnchantmentInfluencer(SimpleParticleType simpleParticleType) {
            this.particle = simpleParticleType;
        }

        @Nullable
        public static EnchantmentInfluencer get(BlockState state) {
            if (state.m_204336_(ModTags.ENCHANTMENT_STABILIZERS) && state.m_60734_() instanceof CandleBlock && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                return STABILIZER;
            }
            if (state.m_204336_(ModTags.CURSE_AUGMENTS)) {
                return CURSE_AGUMENT;
            }
            return null;
        }
    }
}

