/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.enchantery.events;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ordana.enchantery.configs.ClientConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.Container;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class BookshelfNameRendererEvent {
    private static int getHitSlot(Vec2 hitPos) {
        int i = hitPos.f_82471_ >= 0.5f ? 0 : 1;
        int j = BookshelfNameRendererEvent.getSection(hitPos.f_82470_);
        return j + i * 3;
    }

    private static int getSection(float x) {
        float f = 0.0625f;
        float g = 0.375f;
        if (x < 0.375f) {
            return 0;
        }
        float h = 0.6875f;
        return x < 0.6875f ? 1 : 2;
    }

    private static Optional<Vec2> getRelativeHitCoordinatesForBlockFace(BlockHitResult hitResult, Direction face) {
        Direction direction = hitResult.m_82434_();
        if (face != direction) {
            return Optional.empty();
        }
        BlockPos blockPos = hitResult.m_82425_().m_121945_(direction);
        Vec3 vec3 = hitResult.m_82450_().m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        double d = vec3.m_7096_();
        double e = vec3.m_7098_();
        double f = vec3.m_7094_();
        Optional<Vec2> var10000 = switch (direction) {
            case Direction.NORTH -> Optional.of(new Vec2((float)(1.0 - d), (float)e));
            case Direction.SOUTH -> Optional.of(new Vec2((float)d, (float)e));
            case Direction.WEST -> Optional.of(new Vec2((float)f, (float)e));
            case Direction.EAST -> Optional.of(new Vec2((float)(1.0 - f), (float)e));
            case Direction.DOWN, Direction.UP -> Optional.empty();
            default -> throw new IncompatibleClassChangeError();
        };
        return var10000;
    }

    public static List<Component> bookText(ItemStack stack) {
        ArrayList<Component> listText = new ArrayList<Component>();
        listText.add(stack.m_41611_());
        Item item = stack.m_41720_();
        if (item instanceof EnchantedBookItem) {
            EnchantedBookItem book = (EnchantedBookItem)item;
            ListTag storedEnchantments = EnchantedBookItem.m_41163_((ItemStack)stack);
            for (int j = 0; j < storedEnchantments.size(); ++j) {
                CompoundTag compoundTag = storedEnchantments.m_128728_(j);
                BuiltInRegistries.f_256876_.m_6612_(EnchantmentHelper.m_182446_((CompoundTag)compoundTag)).ifPresent(enchantment -> {
                    if (enchantment.m_6589_()) {
                        listText.add((Component)Component.m_237115_((String)enchantment.m_44704_()).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED)));
                    } else {
                        listText.add((Component)Component.m_237115_((String)enchantment.m_44704_()).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.WHITE)));
                    }
                });
            }
        }
        return listText;
    }

    public static void renderBookName(Level level, HitResult blockHit) {
        if (blockHit instanceof BlockHitResult) {
            BlockEntity blockEntity;
            BlockHitResult hit = (BlockHitResult)blockHit;
            BlockPos pos = hit.m_82425_();
            if (ClientConfigs.BOOKSHELF_LABELS_SHIFT.get().booleanValue() && !InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.f_90816_.m_84873_())) {
                return;
            }
            if (level.m_8055_(hit.m_82425_()).m_60734_() instanceof ChiseledBookShelfBlock && (blockEntity = level.m_7702_(pos)) instanceof Container) {
                int i;
                Container bookshelfEntity = (Container)blockEntity;
                BlockState state = level.m_8055_(hit.m_82425_());
                Optional<Vec2> optional = BookshelfNameRendererEvent.getRelativeHitCoordinatesForBlockFace(hit, (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
                if (optional.isPresent() && ((Boolean)state.m_61143_((Property)ChiseledBookShelfBlock.f_260698_.get(i = BookshelfNameRendererEvent.getHitSlot(optional.get())))).booleanValue()) {
                    MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
                    PoseStack matrixStack = new PoseStack();
                    matrixStack.m_252781_(Axis.f_252529_.m_252977_(Minecraft.m_91087_().m_91290_().f_114358_.m_90589_()));
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(Minecraft.m_91087_().m_91290_().f_114358_.m_90590_() + 180.0f));
                    ItemStack stack = bookshelfEntity.m_8020_(i);
                    if (Minecraft.m_91404_() && (stack.m_41788_() || stack.m_41720_() instanceof EnchantedBookItem || stack.m_41720_() instanceof WrittenBookItem)) {
                        List<Component> listText = BookshelfNameRendererEvent.bookText(stack);
                        BookshelfNameRendererEvent.renderNameTag(stack, i, hit.m_82434_(), new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), listText, matrixStack, (MultiBufferSource)bufferSource, level.m_7146_(pos));
                        bufferSource.m_109911_();
                    }
                }
            }
        }
    }

    protected static void renderNameTag(ItemStack stack, int slot, Direction dir, Vec3 pos, List<Component> listText, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        double d = Minecraft.m_91087_().m_91290_().m_114378_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        Vec3 cameraPos = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_();
        matrixStack.m_85837_(pos.f_82479_ - cameraPos.f_82479_, pos.f_82480_ - cameraPos.f_82480_, pos.f_82481_ - cameraPos.f_82481_);
        if (d > 4096.0) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.5f + (float)dir.m_122436_().m_123341_() / 1.3f, 1.2f, 0.5f + (float)dir.m_122436_().m_123343_() / 1.3f);
        switch (slot) {
            case 0: {
                matrixStack.m_85837_((double)dir.m_122436_().m_123343_() * -0.3, 0.0, (double)dir.m_122436_().m_123341_() * 0.3);
                break;
            }
            case 1: {
                matrixStack.m_252880_(0.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                matrixStack.m_85837_((double)dir.m_122436_().m_123343_() * 0.3, 0.0, (double)dir.m_122436_().m_123341_() * -0.3);
                break;
            }
            case 3: {
                matrixStack.m_85837_((double)dir.m_122436_().m_123343_() * -0.3, -0.5, (double)dir.m_122436_().m_123341_() * 0.3);
                break;
            }
            case 4: {
                matrixStack.m_85837_(0.0, -0.5, 0.0);
                break;
            }
            case 5: {
                matrixStack.m_85837_((double)dir.m_122436_().m_123343_() * 0.3, -0.5, (double)dir.m_122436_().m_123341_() * -0.3);
                break;
            }
            default: {
                matrixStack.m_252880_(0.0f, 0.0f, 0.0f);
            }
        }
        matrixStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        matrixStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        float g = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int j = (int)(g * 255.0f) << 24;
        Font font = Minecraft.m_91087_().f_91062_;
        float y = 0.0f;
        for (Component text : listText) {
            float h = (float)(-font.m_92852_((FormattedText)text)) / 2.0f;
            font.m_272077_(text, h, y, ChatFormatting.WHITE.m_126656_(), false, matrix4f, buffer, Font.DisplayMode.NORMAL, j, 0xF000F0);
            y += 10.0f;
        }
        matrixStack.m_85849_();
    }
}

