/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.enchantery.loot_modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ordana.enchantery.Enchantery;
import java.io.InputStream;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.Logger;

public class LootTableOverrides
extends DynServerResourcesGenerator {
    public static final LootTableOverrides INSTANCE = new LootTableOverrides();

    public LootTableOverrides() {
        super(new DynamicDataPack(Enchantery.res("generated_pack"), Pack.Position.TOP, true, true));
        ((DynamicDataPack)this.dynamicPack).setGenerateDebugResources(true);
        ((DynamicDataPack)this.dynamicPack).addNamespaces(new String[]{"minecraft"});
    }

    public Logger getLogger() {
        return Enchantery.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void overrideDataFile(ResourceManager manager, List list, String targetNamespace, String targetPath, String sourcePath, ResType resType) {
        for (Object recipe : list) {
            ResourceLocation target = new ResourceLocation(targetNamespace, targetPath + recipe);
            ResourceLocation source = new ResourceLocation("enchantery", sourcePath + recipe + ".json");
            try {
                InputStream bsStream = ((Resource)manager.m_213713_(source).orElseThrow()).m_215507_();
                try {
                    JsonObject bsElement = RPUtils.deserializeJson((InputStream)bsStream);
                    ((DynamicDataPack)this.dynamicPack).addJson(target, (JsonElement)bsElement, resType);
                }
                finally {
                    if (bsStream == null) continue;
                    bsStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        List<String> lootChestOverrides = List.of("abandoned_mineshaft", "ancient_city", "desert_pyramid", "jungle_temple", "pillager_outpost", "simple_dungeon", "stronghold_corridor", "stronghold_crossing", "stronghold_library", "underwater_ruin_big", "woodland_mansion");
        this.overrideDataFile(manager, lootChestOverrides, "minecraft", "chests/", "overrides/loot_tables/", ResType.LOOT_TABLES);
        List<String> lootGameplayOverrides = List.of("piglin_bartering");
        this.overrideDataFile(manager, lootGameplayOverrides, "minecraft", "gameplay/", "overrides/loot_tables/", ResType.LOOT_TABLES);
    }
}

