/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.enchantery.mixins.forge;

import com.ordana.enchantery.EnchanteryClient;
import com.ordana.enchantery.EnchanteryLogic;
import com.ordana.enchantery.configs.ClientConfigs;
import com.ordana.enchantery.reg.ModEnchants;
import com.ordana.enchantery.reg.ModTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public class TooltipMixin {
    @Inject(method={"appendEnchantmentNames"}, at={@At(value="TAIL")})
    private static void enchantmentTooltips(List<Component> tooltipComponents, ListTag storedEnchantments, CallbackInfo ci) {
        if (!ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue() || storedEnchantments.size() < 1) {
            return;
        }
        if (!EnchanteryClient.isShiftDown()) {
            tooltipComponents.add((Component)Component.m_237113_((String)"[+]").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GREEN)));
        } else {
            for (int i = 0; i < storedEnchantments.size(); ++i) {
                CompoundTag compoundTag = storedEnchantments.m_128728_(i);
                BuiltInRegistries.f_256876_.m_6612_(EnchantmentHelper.m_182446_((CompoundTag)compoundTag)).ifPresent(enchantment -> {
                    Holder<Enchantment> holder = EnchanteryLogic.getHolder(enchantment);
                    String desc = enchantment.m_44704_();
                    if (holder.m_203656_(ModTags.EXEMPT)) {
                        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enchantery.exempt").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_GRAY)));
                    }
                    if (holder.m_203656_(ModTags.BASIC)) {
                        tooltipComponents.add((Component)Component.m_237115_((String)desc).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_PURPLE)));
                        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enchantery.basic").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_PURPLE)));
                    }
                    if (holder.m_203656_(ModTags.TRADEABLE)) {
                        tooltipComponents.add((Component)Component.m_237115_((String)desc).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GREEN)));
                        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enchantery.tradeable").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GREEN)));
                    }
                    if (holder.m_203656_(ModTags.TREASURE)) {
                        tooltipComponents.add((Component)Component.m_237115_((String)desc).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GOLD)));
                        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enchantery.treasure").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GOLD)));
                    }
                    if (!(holder.m_203656_(ModTags.TREASURE) || holder.m_203656_(ModTags.TRADEABLE) || holder.m_203656_(ModTags.BASIC))) {
                        tooltipComponents.add((Component)Component.m_237115_((String)desc).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED)));
                        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enchantery.untagged1").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED)));
                        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enchantery.untagged2").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED)));
                        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enchantery.untagged3").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED)));
                    }
                });
            }
        }
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    public void inventoryTick(Level level, Entity entity, int inventorySlot, boolean isCurrentItem, CallbackInfo ci) {
        EnchanteryLogic.leechingCurseLogic(level, entity, inventorySlot);
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), index=1, argsOnly=true)
    public int extraDamage(int amount) {
        int f = EnchantmentHelper.m_44843_((Enchantment)ModEnchants.DIMINISHING_CURSE.get(), (ItemStack)((ItemStack)this));
        if (f > 0) {
            amount += f;
        }
        return amount;
    }
}

