/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.enchantery.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class RotatingEnchantingParticle
extends TextureSheetParticle {
    private final double targetX;
    private final double targetY;
    private final double targetZ;
    private final double startX;
    private final double startY;
    private final double startZ;
    private final double toCenterAngle;

    protected RotatingEnchantingParticle(ClientLevel clientLevel, double x, double y, double z, double targetX, double targetY, double targetZ) {
        super(clientLevel, x, y - 0.4, z);
        this.startX = x;
        this.startY = y - 0.4;
        this.startZ = z;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        this.toCenterAngle = Math.atan2(targetZ - this.startZ, targetX - this.startX) + 1.5707963267948966;
        this.f_107226_ = 0.0f;
        this.f_107219_ = false;
        this.f_107225_ = 500;
    }

    public void m_5989_() {
        super.m_5989_();
        Vec3 startPos = new Vec3(this.startX, this.startY, this.startZ);
        Vec3 center = new Vec3(this.targetX, this.targetY - 0.5, this.targetZ);
        double targetRadius = 1.25;
        double t = Mth.m_14008_((double)(Math.toRadians(this.f_107224_) / (Math.PI * 2)), (double)0.0, (double)1.0);
        double time = Math.toRadians(this.f_107224_) / t + this.toCenterAngle;
        double x = Mth.m_14139_((double)t, (double)startPos.f_82479_, (double)(center.f_82479_ + Math.cos(time) * -1.0 * targetRadius));
        double y = Mth.m_14139_((double)t, (double)startPos.f_82480_, (double)center.f_82480_);
        double z = Mth.m_14139_((double)t, (double)startPos.f_82481_, (double)(center.f_82481_ + Math.sin(time) * -1.0 * targetRadius));
        this.m_107264_(x, y, z);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public static class ProviderAgument
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public ProviderAgument(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double tableX, double tableY, double tableZ, double relativeX, double relativeY, double relativeZ) {
            RotatingEnchantingParticle p = new RotatingEnchantingParticle(level, tableX + relativeX, tableY + relativeY, tableZ + relativeZ, tableX, tableY, tableZ);
            p.m_108335_(this.sprite);
            return p;
        }
    }

    public static class ProviderStabilizer
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public ProviderStabilizer(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double tableX, double tableY, double tableZ, double relativeX, double relativeY, double relativeZ) {
            RotatingEnchantingParticle p = new RotatingEnchantingParticle(level, tableX + relativeX, tableY + relativeY, tableZ + relativeZ, tableX, tableY, tableZ);
            p.m_108335_(this.sprite);
            return p;
        }
    }

    public static class ProviderCurse
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public ProviderCurse(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double tableX, double tableY, double tableZ, double relativeX, double relativeY, double relativeZ) {
            RotatingEnchantingParticle p = new RotatingEnchantingParticle(level, tableX + relativeX, tableY + relativeY, tableZ + relativeZ, tableX, tableY, tableZ);
            p.m_108335_(this.sprite);
            return p;
        }
    }
}

