/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.villagerinabucket.config;

import com.imjustdoom.villagerinabucket.config.fabric.ConfigImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Config {
    private static Path FILE_PATH;
    private static Properties PROPERTIES;
    public static boolean ZOMBIE_VILLAGER;

    public static void init() throws IOException {
        PROPERTIES = new Properties();
        FILE_PATH = Path.of(String.valueOf(Config.getConfigDirectory()) + "/villager-in-a-bucket.properties", new String[0]);
        if (!FILE_PATH.toFile().exists()) {
            new File(FILE_PATH.toString()).createNewFile();
        }
        PROPERTIES.load(new FileInputStream(FILE_PATH.toFile()));
        ZOMBIE_VILLAGER = Config.getBoolean("enable-zombie-villager", "true");
        Config.save();
    }

    private static String getString(String setting, String defaultValue) {
        String value = PROPERTIES.getProperty(setting);
        if (value == null) {
            PROPERTIES.setProperty(setting, defaultValue);
            value = defaultValue;
        }
        return value;
    }

    private static int getInt(String setting, String defaultValue) {
        String value = PROPERTIES.getProperty(setting);
        if (value == null) {
            PROPERTIES.setProperty(setting, defaultValue);
            value = defaultValue;
        }
        return Integer.parseInt(value);
    }

    private static float getFloat(String setting, String defaultValue) {
        String value = PROPERTIES.getProperty(setting);
        if (value == null) {
            PROPERTIES.setProperty(setting, defaultValue);
            value = defaultValue;
        }
        return Float.parseFloat(value);
    }

    private static boolean getBoolean(String setting, String defaultValue) {
        String value = PROPERTIES.getProperty(setting);
        if (value == null) {
            PROPERTIES.setProperty(setting, defaultValue);
            value = defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static List<String> getStringList(String setting, String defaultValue) {
        String value = PROPERTIES.getProperty(setting);
        if (value == null) {
            PROPERTIES.setProperty(setting, defaultValue);
            value = defaultValue;
        }
        return Arrays.asList(value.split(","));
    }

    public static void save() throws IOException {
        PROPERTIES.store(new FileWriter(FILE_PATH.toFile()), "Config for Villager In A Bucket\n'enable-zombie-villager' should the ability to pick up Zombie Villagers in buckets be enabled. Default true\n");
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigDirectory() {
        return ConfigImpl.getConfigDirectory();
    }
}

