/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.villagerinabucket;

import com.destroystokyo.paper.entity.villager.Reputation;
import com.destroystokyo.paper.entity.villager.ReputationType;
import com.imjustdoom.villagerinabucket.Config;
import com.imjustdoom.villagerinabucket.bstats.bukkit.Metrics;
import com.imjustdoom.villagerinabucket.bstats.charts.SimplePie;
import com.imjustdoom.villagerinabucket.event.PreVillagerPickupEvent;
import com.imjustdoom.villagerinabucket.event.PreVillagerPlaceEvent;
import com.imjustdoom.villagerinabucket.event.VillagerPickupEvent;
import com.imjustdoom.villagerinabucket.event.VillagerPlaceEvent;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackInfoLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class VillagerInABucket
extends JavaPlugin
implements Listener {
    private final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static String PREFIX = "[VIAB]";
    public static TextColor TEXT_COLOR = TextColor.color((int)2, (int)220, (int)5);
    public NamespacedKey key = new NamespacedKey((Plugin)this, "villager_data");
    public FileWriter logFileWriter;
    private static VillagerInABucket INSTANCE;

    public VillagerInABucket() {
        INSTANCE = this;
    }

    public void onEnable() {
        Config.init();
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            LiteralCommandNode buildCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"villagerinabucket").requires(sender -> sender.getSender().hasPermission("villagerinabucket.commands"))).executes(ctx -> {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)(PREFIX + " VillagerInABucket version " + this.getPluginMeta().getVersion()), (TextColor)TEXT_COLOR));
                return 1;
            })).then(Commands.literal((String)"reload").executes(ctx -> {
                Config.init();
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)(PREFIX + " VillagerInABucket has been reloaded!"), (TextColor)TEXT_COLOR));
                return 1;
            }))).build();
            ((Commands)commands.registrar()).register(buildCommand, List.of("viab"));
        });
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Metrics metrics = new Metrics((Plugin)this, 25722);
        metrics.addCustomChart(new SimplePie("updated_to_new_settings", () -> String.valueOf(Config.PERMISSIONS)));
        metrics.addCustomChart(new SimplePie("usingResourcepack", () -> String.valueOf(Config.RESOURCE_PACK)));
    }

    public void onDisable() {
        if (this.logFileWriter != null) {
            try {
                this.logFileWriter.close();
            }
            catch (IOException e) {
                this.getLogger().severe("Unable to close villager action file logger");
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!Config.RESOURCE_PACK) {
            return;
        }
        try {
            event.getPlayer().sendResourcePacks((ResourcePackInfoLike)ResourcePackInfo.resourcePackInfo((UUID)UUID.fromString(Config.RESOURCE_PACK_ID), (URI)URI.create(Config.RESOURCE_PACK_URL), (String)Config.RESOURCE_PACK_HASH), new ResourcePackInfoLike[0]);
        }
        catch (IllegalArgumentException exception) {
            this.getLogger().severe("The UUID '" + Config.RESOURCE_PACK_ID + "' is invalid");
        }
    }

    public boolean isVillagerBucket(ItemStack itemStack) {
        if (itemStack.getType() != Material.BUCKET || itemStack.getItemMeta() == null) {
            return false;
        }
        PersistentDataContainer dataContainer = itemStack.getItemMeta().getPersistentDataContainer();
        return dataContainer.has(this.key) && dataContainer.get(this.key, PersistentDataType.BYTE_ARRAY) != null;
    }

    public void createVillagerBucket(ItemStack itemStack, Entity entity, Player player) {
        entity.setVelocity(new Vector(0, 0, 0));
        entity.setFallDistance(0.0f);
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Villager.class, ZombieVillager.class, WanderingTrader.class}, (Object)entity3, n)) {
            case 0: {
                Villager villager = (Villager)entity3;
                if (!entity.isSilent()) {
                    player.getWorld().playSound(entity.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                }
                itemStack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addString(villager.getVillagerType().key().value()).build()));
                break;
            }
            case 1: {
                ZombieVillager zombieVillager = (ZombieVillager)entity3;
                if (!entity.isSilent()) {
                    player.getWorld().playSound(entity.getLocation(), Sound.ENTITY_ZOMBIE_VILLAGER_AMBIENT, 1.0f, 1.0f);
                }
                itemStack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addString("zombie_villager").build()));
                break;
            }
            case 2: {
                WanderingTrader trader = (WanderingTrader)entity3;
                if (!entity.isSilent()) {
                    player.getWorld().playSound(entity.getLocation(), Sound.ENTITY_WANDERING_TRADER_NO, 1.0f, 1.0f);
                }
                itemStack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addString("wandering_trader").build()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(entity));
            }
        }
        itemStack.editMeta(meta -> {
            Entity entity2 = entity;
            Objects.requireNonNull(entity2);
            Entity selector0$temp = entity2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Villager.class, ZombieVillager.class, WanderingTrader.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    Villager villager = (Villager)selector0$temp;
                    if (Config.HARM_REPUTATION && !Config.PERMISSIONS || Config.PERMISSIONS && player.hasPermission("villagerinabucket.harm-reputation")) {
                        Reputation reputation;
                        int minorRep = (reputation = villager.getReputation(player.getUniqueId())).getReputation(ReputationType.MINOR_NEGATIVE);
                        reputation.setReputation(ReputationType.MINOR_NEGATIVE, minorRep >= 175 ? 200 : minorRep + 25);
                        villager.setReputation(player.getUniqueId(), reputation);
                    }
                    meta.itemName((Component)Component.text((String)"Villager In A Bucket"));
                    ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                    lore.add(Component.text((String)("Level: " + villager.getVillagerLevel()), (TextColor)TextColor.color((int)Color.GRAY.asRGB()), (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
                    lore.add(Component.text((String)("Region: " + villager.getVillagerType().getKey().getKey().toUpperCase()), (TextColor)TextColor.color((int)Color.GRAY.asRGB()), (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
                    lore.add(Component.text((String)("Profession: " + String.valueOf(villager.getProfession())), (TextColor)TextColor.color((int)Color.GRAY.asRGB()), (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
                    if (!villager.isAdult()) {
                        lore.add(Component.text((String)"Baby", (TextColor)TextColor.color((int)Color.GRAY.asRGB()), (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
                    }
                    meta.lore(lore);
                    break;
                }
                case 1: {
                    ZombieVillager zombieVillager = (ZombieVillager)selector0$temp;
                    meta.itemName((Component)Component.text((String)"Zombie Villager In A Bucket"));
                    ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                    if (!zombieVillager.isAdult()) {
                        lore.add(Component.text((String)"Baby", (TextColor)TextColor.color((int)Color.GRAY.asRGB()), (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
                    }
                    meta.lore(lore);
                    break;
                }
                case 2: {
                    WanderingTrader wanderingTrader = (WanderingTrader)selector0$temp;
                    meta.itemName((Component)Component.text((String)"Wandering Trader In A Bucket"));
                    ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                    if (!wanderingTrader.isAdult()) {
                        lore.add(Component.text((String)"Baby", (TextColor)TextColor.color((int)Color.GRAY.asRGB()), (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
                    }
                    meta.lore(lore);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(entity));
                }
            }
            meta.getPersistentDataContainer().set(this.key, PersistentDataType.BYTE_ARRAY, (Object)Bukkit.getUnsafe().serializeEntity(entity));
            meta.setMaxStackSize(Integer.valueOf(1));
        });
    }

    @EventHandler
    public void villagerInteract(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        ItemStack itemStack = player.getInventory().getItem(event.getHand());
        Entity clicked = event.getRightClicked();
        if (itemStack.getType() != Material.BUCKET) {
            return;
        }
        if (this.isVillagerBucket(itemStack)) {
            event.setCancelled(true);
            return;
        }
        if ((clicked.getType() != EntityType.VILLAGER || !Config.VILLAGER && !Config.PERMISSIONS || Config.PERMISSIONS && !player.hasPermission("villagerinabucket.villager.pickup")) && (clicked.getType() != EntityType.WANDERING_TRADER || !Config.WANDERING_TRADER && !Config.PERMISSIONS || Config.PERMISSIONS && !player.hasPermission("villagerinabucket.wandering_trader.pickup")) && (clicked.getType() != EntityType.ZOMBIE_VILLAGER || !Config.ZOMBIE_VILLAGER && !Config.PERMISSIONS || Config.PERMISSIONS && !player.hasPermission("villagerinabucket.zombie_villager.pickup"))) {
            return;
        }
        Location location = clicked.getLocation();
        PreVillagerPickupEvent preVillagerPickupEvent = new PreVillagerPickupEvent(clicked, player, location, itemStack);
        if (!preVillagerPickupEvent.callEvent()) {
            return;
        }
        if (itemStack.getAmount() > 1 || player.getGameMode() == GameMode.CREATIVE) {
            ItemStack newStack = new ItemStack(Material.BUCKET);
            this.createVillagerBucket(newStack, clicked, player);
            if (player.getGameMode() != GameMode.CREATIVE) {
                itemStack.setAmount(itemStack.getAmount() - 1);
            }
            player.getInventory().addItem(new ItemStack[]{newStack});
            itemStack = newStack;
        } else {
            this.createVillagerBucket(itemStack, clicked, player);
        }
        clicked.remove();
        event.setCancelled(true);
        this.log("PICKUP", player, clicked, location);
        VillagerPickupEvent villagerPickupEvent = new VillagerPickupEvent(clicked, player, location, itemStack);
        villagerPickupEvent.callEvent();
    }

    @EventHandler
    public void bucketInteract(PlayerInteractEvent event) {
        PreVillagerPlaceEvent preVillagerPlaceEvent;
        Player player = event.getPlayer();
        ItemStack itemStack = event.getItem();
        if (event.getInteractionPoint() == null) {
            return;
        }
        if (!event.getAction().isRightClick() || itemStack == null || !this.isVillagerBucket(itemStack)) {
            return;
        }
        event.setCancelled(true);
        if (event.getClickedBlock() == null) {
            return;
        }
        PersistentDataContainer dataContainer = itemStack.getItemMeta().getPersistentDataContainer();
        LivingEntity entity = (LivingEntity)Bukkit.getUnsafe().deserializeEntity((byte[])dataContainer.get(this.key, PersistentDataType.BYTE_ARRAY), player.getWorld());
        if ((!Config.VILLAGER && entity.getType() == EntityType.VILLAGER || !Config.ZOMBIE_VILLAGER && entity.getType() == EntityType.ZOMBIE_VILLAGER || !Config.WANDERING_TRADER && entity.getType() == EntityType.WANDERING_TRADER) && Config.DISABLE_PLACING_OF_DISABLED && !Config.PERMISSIONS || !player.hasPermission("villagerinabucket.villager.place") && entity.getType() == EntityType.VILLAGER || !player.hasPermission("villagerinabucket.zombie_villager.place") && entity.getType() == EntityType.ZOMBIE_VILLAGER || !player.hasPermission("villagerinabucket.wandering_trader.place") && entity.getType() == EntityType.WANDERING_TRADER && Config.PERMISSIONS) {
            player.sendMessage((Component)Component.text((String)"You are not allowed to place this villager"));
            return;
        }
        BlockFace clickedFace = event.getBlockFace();
        Location location = event.getInteractionPoint().clone().add((double)((float)clickedFace.getModX() * 0.5f), 0.0, (double)((float)clickedFace.getModZ() * 0.5f));
        if (clickedFace == BlockFace.DOWN) {
            location.subtract(0.0, entity.getHeight(), 0.0);
        }
        if (player.getWorld().getBlockAt(location.clone().subtract(0.0, 1.0, 0.0)).isSolid()) {
            location.setY(Math.floor(location.getY()));
        }
        if (player.getWorld().getBlockAt(location).isSolid()) {
            location.setY(Math.floor(location.getY()) + 1.0);
        }
        if (!(preVillagerPlaceEvent = new PreVillagerPlaceEvent((Entity)entity, player, location, itemStack)).callEvent()) {
            return;
        }
        entity.spawnAt(location, CreatureSpawnEvent.SpawnReason.BUCKET);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.unsetData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA);
            itemStack.editMeta(meta -> {
                String customName;
                meta.itemName(null);
                if (meta.hasCustomName() && ((customName = ((TextComponent)meta.customName()).content()).equals("Villager In A Bucket") || customName.equals("Zombie Villager In A Bucket") || customName.equals("Wandering Trader In A Bucket"))) {
                    meta.customName(null);
                }
                meta.getPersistentDataContainer().remove(this.key);
                meta.setMaxStackSize(null);
                if (meta.hasLore()) {
                    meta.lore(null);
                }
            });
        }
        if (!entity.isSilent()) {
            LivingEntity livingEntity = entity;
            Objects.requireNonNull(livingEntity);
            LivingEntity livingEntity2 = livingEntity;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Villager.class, ZombieVillager.class, WanderingTrader.class}, (Object)livingEntity2, n)) {
                case 0: {
                    Villager villager = (Villager)livingEntity2;
                    if (entity.isSilent()) break;
                    player.getWorld().playSound(entity.getLocation(), Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    ZombieVillager zombieVillager = (ZombieVillager)livingEntity2;
                    if (entity.isSilent()) break;
                    player.getWorld().playSound(entity.getLocation(), Sound.ENTITY_ZOMBIE_VILLAGER_AMBIENT, 1.0f, 1.0f);
                    break;
                }
                case 2: {
                    WanderingTrader trader = (WanderingTrader)livingEntity2;
                    if (entity.isSilent()) break;
                    player.getWorld().playSound(entity.getLocation(), Sound.ENTITY_WANDERING_TRADER_YES, 1.0f, 1.0f);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(entity));
                }
            }
        }
        this.log("PLACE", player, (Entity)entity, location);
        VillagerPlaceEvent villagerPlaceEvent = new VillagerPlaceEvent((Entity)entity, player, location, itemStack);
        villagerPlaceEvent.callEvent();
    }

    public void log(String action, Player player, Entity entity, Location location) {
        String message = String.format("[DEBUG] [%s] - Player: %s - Entity: %s - Location: %s", action, player.getName(), entity, location);
        if (Config.CONSOLE_LOGGING) {
            this.getLogger().info(message);
        }
        if (Config.FILE_LOGGING) {
            try {
                this.logFileWriter.write("[" + LocalDateTime.now().format(this.TIMESTAMP_FORMAT) + "] " + message + System.lineSeparator());
            }
            catch (IOException e) {
                this.getLogger().severe("Unable to write to log file: " + e.getMessage());
            }
        }
    }

    public static VillagerInABucket get() {
        return INSTANCE;
    }
}

