/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.villagerinabucket;

import com.imjustdoom.villagerinabucket.config.Config;
import com.imjustdoom.villagerinabucket.item.ModItems;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VillagerInABucket {
    public static final String MOD_ID = "villagerinabucket";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"villagerinabucket");
    public static final Map<VillagerType, Integer> VILLAGER_DATA_LIST = new HashMap<VillagerType, Integer>(){
        {
            this.put(VillagerType.DESERT, 1);
            this.put(VillagerType.SAVANNA, 2);
            this.put(VillagerType.SNOW, 3);
            this.put(VillagerType.SWAMP, 4);
        }
    };

    public static void registerDispenserBehaviours() {
        DefaultDispenseItemBehavior dispenseItemBehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
                DispensibleContainerItem dispensibleContainerItem = (DispensibleContainerItem)itemStack.getItem();
                BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = blockSource.level();
                if (dispensibleContainerItem.emptyContents(null, (Level)level, blockPos, null)) {
                    dispensibleContainerItem.checkExtraContent(null, (Level)level, itemStack, blockPos);
                    return new ItemStack((ItemLike)Items.BUCKET);
                }
                return this.defaultDispenseItemBehavior.dispense(blockSource, itemStack);
            }
        };
        DispenserBlock.registerBehavior((ItemLike)ModItems.VILLAGER_IN_A_BUCKET, (DispenseItemBehavior)dispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)ModItems.WANDERING_TRADER_IN_A_BUCKET, (DispenseItemBehavior)dispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)ModItems.ZOMBIE_VILLAGER_IN_A_BUCKET, (DispenseItemBehavior)dispenseItemBehavior);
    }

    public static void init() {
        try {
            Config.init();
        }
        catch (IOException exception) {
            System.err.println("There was an error setting up or saving the config file for Villager In A Bucket :(");
            exception.printStackTrace();
        }
    }
}

