/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.villagerinabucket.item.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerBucket
extends MobBucketItem {
    public static final MapCodec<VillagerData> CODEC = VillagerData.CODEC.fieldOf("VillagerData");

    public VillagerBucket(EntityType<? extends Mob> entityType, SoundEvent soundEvent, Item.Properties properties) {
        super(entityType, Fluids.EMPTY, soundEvent, properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        BlockHitResult blockHitResult = VillagerBucket.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        if (level.mayInteract(player, blockPos)) {
            CustomData oldData;
            if (((CustomData)itemStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY)).isEmpty() && !(oldData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).isEmpty()) {
                oldData.read(CODEC).result().ifPresent(villagerData -> itemStack.set(DataComponents.BUCKET_ENTITY_DATA, (Object)oldData));
            }
            this.checkExtraContent(player, level, itemStack, blockPos);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockPos, itemStack);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)VillagerBucket.getEmptySuccessItem((ItemStack)itemStack, (Player)player), (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (customData.isEmpty() && (customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).isEmpty()) {
            return;
        }
        Optional optional = customData.read(CODEC).result();
        if (optional.isPresent()) {
            VillagerData data = (VillagerData)optional.get();
            ChatFormatting[] chatFormattings = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
            list.add((Component)Component.translatable((String)("Level: " + data.getLevel())).withStyle(chatFormattings));
            String type = data.getType().toString();
            String region = I18n.get((String)(type.equals("snow") ? "block.minecraft.snow" : "biome.minecraft." + type), (Object[])new Object[0]);
            list.add((Component)Component.translatable((String)("Region: " + region)).withStyle(chatFormattings));
            String profession = I18n.get((String)("entity.minecraft.villager." + data.getProfession().toString()), (Object[])new Object[0]);
            list.add((Component)Component.translatable((String)("Profession: " + profession)).withStyle(chatFormattings));
            if (customData.contains("Age") && customData.copyTag().getInt("Age") < 0) {
                list.add((Component)Component.literal((String)"Baby").withStyle(chatFormattings));
            }
        }
    }

    public boolean emptyContents(@Nullable Player player, Level level, BlockPos blockPos, @Nullable BlockHitResult blockHitResult) {
        BlockState blockstate = level.getBlockState(blockPos);
        if (blockstate.isAir() || blockstate.canBeReplaced(Fluids.EMPTY)) {
            this.playEmptySound(player, (LevelAccessor)level, blockPos);
            return true;
        }
        return false;
    }
}

