/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.villagerinabucket.mixin;

import com.imjustdoom.villagerinabucket.VillagerBucketable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/core/dispenser/DispenseItemBehavior$17"})
public abstract class DispenseBucketBehaviorMixin {
    @Inject(method={"execute(Lnet/minecraft/core/dispenser/BlockSource;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void execute(BlockSource blockSource, ItemStack itemStack, CallbackInfoReturnable<ItemStack> cir) {
        ServerLevel serverLevel = blockSource.level();
        if (!serverLevel.isClientSide()) {
            BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
            List list = serverLevel.getEntitiesOfClass(LivingEntity.class, new AABB(blockPos), EntitySelector.NO_SPECTATORS);
            for (LivingEntity livingEntity : list) {
                if (!livingEntity.isAlive() || !(livingEntity instanceof VillagerBucketable)) continue;
                VillagerBucketable villager = (VillagerBucketable)livingEntity;
                ItemStack stack = villager.createBucketStack();
                livingEntity.discard();
                cir.setReturnValue((Object)this.villagerinabucket$consume(blockSource, itemStack, stack));
                return;
            }
        }
    }

    @Unique
    private ItemStack villagerinabucket$consume(BlockSource blockSource, ItemStack stack, ItemStack remainder) {
        stack.shrink(1);
        if (stack.isEmpty()) {
            return remainder;
        }
        if (blockSource.blockEntity().addItem(remainder) < 0) {
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            DefaultDispenseItemBehavior.spawnItem((Level)blockSource.level(), (ItemStack)stack, (int)6, (Direction)direction, (Position)DispenserBlock.getDispensePosition((BlockSource)blockSource));
            blockSource.level().levelEvent(1000, blockSource.pos(), 0);
            blockSource.level().levelEvent(2000, blockSource.pos(), direction.get3DDataValue());
        }
        return stack;
    }
}

