/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.villagerinabucket.mixin;

import com.imjustdoom.villagerinabucket.VillagerBucketable;
import com.imjustdoom.villagerinabucket.config.Config;
import com.imjustdoom.villagerinabucket.item.ModItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ZombieVillager.class})
public abstract class ZombieVillagerMixin
extends Zombie
implements Bucketable,
VillagerBucketable {
    @Unique
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(ZombieVillagerMixin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public ZombieVillagerMixin(EntityType<? extends Zombie> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void mobInteract(Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (this.level().isClientSide() || itemStack.getItem() != Items.BUCKET || !this.isAlive() || !Config.ZOMBIE_VILLAGER) {
            return;
        }
        this.playSound(this.getPickupSound(), 1.0f, 1.0f);
        player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)this.createBucketStack(), (boolean)false));
        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, this.getBucketItemStack());
        this.discard();
        cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)this.level().isClientSide()));
    }

    @Override
    public ItemStack createBucketStack() {
        ItemStack villagerBucket = this.getBucketItemStack();
        this.saveToBucketTag(villagerBucket);
        return villagerBucket;
    }

    @Inject(at={@At(value="HEAD")}, method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"})
    public void defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(FROM_BUCKET, (Object)false);
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    public void addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("FromBucket", this.fromBucket());
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    public void readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        super.readAdditionalSaveData(compound);
        this.setFromBucket(compound.getBoolean("FromBucket"));
    }

    public boolean fromBucket() {
        return (Boolean)this.getEntityData().get(FROM_BUCKET);
    }

    public void setFromBucket(boolean fromBucket) {
        this.getEntityData().set(FROM_BUCKET, (Object)fromBucket);
    }

    public void saveToBucketTag(ItemStack itemStack) {
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, arg_0 -> ((ZombieVillagerMixin)this).addAdditionalSaveData(arg_0));
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)itemStack);
    }

    public void loadFromBucketTag(CompoundTag compoundTag) {
        this.readAdditionalSaveData(compoundTag);
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)compoundTag);
    }

    @NotNull
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ModItems.ZOMBIE_VILLAGER_IN_A_BUCKET);
    }

    @NotNull
    public SoundEvent getPickupSound() {
        return SoundEvents.ZOMBIE_VILLAGER_AMBIENT;
    }
}

