/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.collector;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.lushplugins.pluginupdater.PluginUpdater;
import org.lushplugins.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pluginupdater.api.platform.hangar.HangarData;
import org.lushplugins.pluginupdater.api.platform.modrinth.ModrinthData;
import org.lushplugins.pluginupdater.api.platform.spigot.SpigotData;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.collector.PluginDataCollector;
import org.lushplugins.pluginupdater.config.ConfigManager;

public class PluginYamlCollector
implements PluginDataCollector {
    @Override
    public List<PluginData> collectPlugins(Collection<JavaPlugin> unknownPlugins) {
        ConfigManager configManager = PluginUpdater.getInstance().getConfigManager();
        ArrayList<PluginData> pluginDataList = new ArrayList<PluginData>();
        for (Plugin plugin : unknownPlugins) {
            InputStream pluginInputStream;
            String pluginName = plugin.getName();
            if (!configManager.canRegisterPluginData(pluginName) || (pluginInputStream = plugin.getResource("plugin.yml")) == null) continue;
            YamlConfiguration pluginYml = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(pluginInputStream));
            PlatformData platformData = null;
            if (pluginYml.contains("modrinth-project-id")) {
                platformData = new ModrinthData(pluginYml.getString("modrinth-project-id"), true);
            } else if (pluginYml.contains("spigot-resource-id")) {
                platformData = new SpigotData(pluginYml.getString("spigot-resource-id"));
            } else if (pluginYml.contains("hangar-project-slug")) {
                platformData = new HangarData(pluginYml.getString("hangar-project-slug"));
            }
            if (platformData == null) continue;
            pluginDataList.add(new PluginData(plugin, platformData));
        }
        return pluginDataList;
    }
}

