/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.command;

import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.command.CommandSender;
import org.lushplugins.pluginupdater.PluginUpdater;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.api.version.VersionDifference;
import org.lushplugins.pluginupdater.libraries.lushlib.libraries.chatcolor.ChatColorHandler;
import org.lushplugins.pluginupdater.updater.UpdateHandler;
import org.lushplugins.pluginupdater.util.lamp.annotation.PluginName;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Switch;
import revxrsal.commands.bukkit.annotation.CommandPermission;

public class UpdateCommand {
    @Command(value={"updater update"})
    @CommandPermission(value="pluginupdater.downloadupdates")
    public String update(CommandSender sender, @PluginName String pluginName) {
        if (!PluginUpdater.getInstance().getConfigManager().shouldAllowDownloads()) {
            return "&#ff6969Update downloads have been disabled in the config";
        }
        PluginData pluginData = PluginUpdater.getInstance().getConfigManager().getPluginData(pluginName);
        if (pluginData == null) {
            return "&#ff6969That plugin is not registered";
        }
        if (!pluginData.areDownloadsAllowed()) {
            return "&#ff6969Downloads are disabled for that plugin, to allow downloads manually add it to your config";
        }
        if (pluginData.isAlreadyDownloaded()) {
            return "&#ffda54You have already downloaded an update for this plugin - please restart your server";
        }
        if (!pluginData.isUpdateAvailable()) {
            return "&#ff6969No update has been found for this plugin";
        }
        PluginUpdater.getInstance().getUpdateHandler().queueDownload(pluginData.getPluginName());
        return "&#b7faa2Successfully queued an update for '%s'".formatted(pluginData.getPluginName());
    }

    @Command(value={"updater update all"})
    @CommandPermission(value="pluginupdater.downloadupdates")
    public String updateAll(CommandSender sender, @Switch(value="force") boolean force) {
        UpdateHandler updateHandler = PluginUpdater.getInstance().getUpdateHandler();
        AtomicInteger updateCount = new AtomicInteger(0);
        AtomicInteger majorUpdateCount = new AtomicInteger(0);
        PluginUpdater.getInstance().getConfigManager().getAllPluginData().forEach(pluginData -> {
            if (!pluginData.areDownloadsAllowed()) {
                return;
            }
            if (pluginData.isAlreadyDownloaded() || !pluginData.isUpdateAvailable()) {
                return;
            }
            if (pluginData.getVersionDifference().equals((Object)VersionDifference.MAJOR) && !force) {
                majorUpdateCount.incrementAndGet();
                return;
            }
            updateHandler.queueDownload(pluginData.getPluginName());
            updateCount.incrementAndGet();
        });
        int finalCount = updateCount.get();
        int finalMajorCount = majorUpdateCount.get();
        if (finalCount == 0 && finalMajorCount == 0) {
            ChatColorHandler.sendMessage(sender, "&#ff6969No updates found");
        } else if (finalCount > 0) {
            ChatColorHandler.sendMessage(sender, "&#b7faa2Successfully queued an update for %s plugins".formatted(finalCount));
        }
        if (finalMajorCount > 0) {
            ChatColorHandler.sendMessage(sender, "&#e0c01b%s &#ffe27aplugins require major updates, run &#e0c01b/updates update all --force &#ffe27ato force all possible updates".formatted(finalMajorCount));
        }
        return null;
    }
}

