/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.pluginupdater.PluginUpdater;
import org.lushplugins.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pluginupdater.api.platform.PlatformRegistry;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.collector.PluginDataCollector;
import org.lushplugins.pluginupdater.updater.UpdateHandler;

public class ConfigManager {
    private boolean allowDownloads;
    private final Map<String, PluginData> plugins = new TreeMap<String, PluginData>(String.CASE_INSENSITIVE_ORDER);
    private final HashSet<String> disabledPlugins = new HashSet();
    private final HashMap<String, String> messages = new HashMap();

    public ConfigManager() {
        PluginUpdater.getInstance().saveDefaultConfig();
    }

    public void reloadConfig() {
        boolean checkOnReload;
        PluginUpdater plugin = PluginUpdater.getInstance();
        plugin.reloadConfig();
        FileConfiguration config = plugin.getConfig();
        if (config.contains("check-updates-on-start")) {
            checkOnReload = config.getBoolean("check-updates-on-start", true);
            PluginUpdater.getInstance().getLogger().log(Level.WARNING, "Deprecated: The config section 'check-updates-on-start' has been renamed to 'check-updates-on-reload'");
        } else {
            checkOnReload = config.getBoolean("check-updates-on-reload", true);
        }
        this.allowDownloads = config.getBoolean("allow-downloads", true);
        ConfigurationSection messagesSection = config.getConfigurationSection("messages");
        if (messagesSection != null) {
            ConfigManager.getConfigurationSections(messagesSection).forEach(messageSection -> {
                String messageName = messageSection.getName();
                this.setMessage(messageName, messagesSection.getString(messageName));
            });
        }
        ArrayList<PluginData> dataSnapshot = new ArrayList<PluginData>(this.plugins.values());
        for (PluginData snapshot : dataSnapshot) {
            if (snapshot.isAlreadyDownloaded()) continue;
            this.plugins.remove(snapshot.getPluginName());
        }
        ConfigurationSection pluginsSection = config.getConfigurationSection("plugins");
        if (pluginsSection != null) {
            ConfigManager.getConfigurationSections(pluginsSection).forEach(pluginSection -> {
                String pluginName = pluginSection.getName();
                boolean enabled = pluginSection.getBoolean("enabled", true);
                boolean allowDownloads = pluginSection.getBoolean("allow-downloads", true);
                String platform = pluginSection.getString("platform");
                if (!enabled) {
                    this.disabledPlugins.add(pluginName);
                    return;
                }
                if (platform == null) {
                    return;
                }
                Plugin currPlugin = Bukkit.getPluginManager().getPlugin(pluginName);
                if (currPlugin == null) {
                    return;
                }
                try {
                    PlatformData platformData = PlatformRegistry.getPlatformData(platform, pluginSection);
                    if (platformData != null) {
                        this.addPlugin(pluginName, new PluginData(currPlugin, platformData, allowDownloads));
                    }
                }
                catch (Exception e) {
                    plugin.getLogger().log(Level.SEVERE, "Caught error whilst collecting data for '%s'".formatted(pluginName), e);
                }
            });
        }
        PluginDataCollector.collectUnknownPlugins().thenAccept(collectedPluginData -> {
            for (PluginData pluginData : collectedPluginData) {
                this.addPlugin(pluginData);
            }
            if (checkOnReload) {
                UpdateHandler updateHandler = PluginUpdater.getInstance().getUpdateHandler();
                this.getPlugins().forEach(updateHandler::queueUpdateCheck);
            }
        });
    }

    public boolean shouldAllowDownloads() {
        return this.allowDownloads;
    }

    public boolean canRegisterPluginData(String pluginName) {
        return !this.plugins.containsKey(pluginName) && !this.disabledPlugins.contains(pluginName);
    }

    public Set<String> getPlugins() {
        return this.plugins.keySet();
    }

    public Collection<PluginData> getAllPluginData() {
        return this.plugins.values();
    }

    @Nullable
    public PluginData getPluginData(String pluginName) {
        return this.plugins.get(pluginName);
    }

    public void addPlugin(@NotNull PluginData pluginData) {
        this.addPlugin(pluginData.getPluginName(), pluginData);
    }

    public void addPlugin(String pluginName, @NotNull PluginData pluginData) {
        this.plugins.put(pluginName, pluginData);
    }

    public void removePlugin(String pluginName) {
        this.plugins.remove(pluginName);
    }

    @Nullable
    public String getMessage(String name) {
        return this.getMessage(name, null);
    }

    public String getMessage(String name, String def) {
        return this.messages.getOrDefault(name, def);
    }

    public void setMessage(@NotNull String name, @NotNull String message) {
        this.messages.put(name, message);
    }

    public static List<ConfigurationSection> getConfigurationSections(ConfigurationSection configurationSection) {
        return configurationSection.getValues(false).values().stream().filter(sectionRaw -> sectionRaw instanceof ConfigurationSection).map(sectionRaw -> (ConfigurationSection)sectionRaw).toList();
    }
}

