/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.api.platform.github;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.http.HttpResponse;
import org.lushplugins.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pluginupdater.api.platform.github.GithubData;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.api.util.HttpUtil;
import org.lushplugins.pluginupdater.api.version.VersionChecker;

public class GithubVersionChecker
implements VersionChecker {
    @Override
    public String getLatestVersion(PluginData pluginData, PlatformData platformData) throws IOException, InterruptedException {
        if (!(platformData instanceof GithubData)) {
            return null;
        }
        GithubData githubData = (GithubData)platformData;
        JsonObject releaseJson = this.getLatestRelease(pluginData, githubData);
        return releaseJson.get("tag_name").getAsString();
    }

    @Override
    public String getDownloadUrl(PluginData pluginData, PlatformData platformData) throws IOException, InterruptedException {
        if (!(platformData instanceof GithubData)) {
            return null;
        }
        GithubData githubData = (GithubData)platformData;
        JsonObject releaseJson = this.getLatestRelease(pluginData, githubData);
        JsonArray assetsJson = releaseJson.get("assets").getAsJsonArray();
        return assetsJson.get(0).getAsJsonObject().get("browser_download_url").getAsString();
    }

    private JsonObject getLatestRelease(PluginData pluginData, GithubData githubData) throws IOException, InterruptedException {
        HttpResponse<String> response = HttpUtil.sendRequest(String.format("%s/repos/%s/releases/latest", "https://api.github.com", githubData.getGithubRepo()));
        if (response.statusCode() != 200) {
            throw new IllegalStateException("Received invalid response code (%s) whilst checking '%s' for updates.".formatted(response.statusCode(), pluginData.getPluginName()));
        }
        return JsonParser.parseString((String)response.body()).getAsJsonObject();
    }
}

