/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.api.platform.hangar;

import java.io.IOException;
import java.net.http.HttpResponse;
import org.lushplugins.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pluginupdater.api.platform.hangar.HangarData;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.api.util.HttpUtil;
import org.lushplugins.pluginupdater.api.version.VersionChecker;

public class HangarVersionChecker
implements VersionChecker {
    @Override
    public String getLatestVersion(PluginData pluginData, PlatformData platformData) throws IOException, InterruptedException {
        if (!(platformData instanceof HangarData)) {
            return null;
        }
        HangarData hangarData = (HangarData)platformData;
        HttpResponse<String> response = HttpUtil.sendRequest(String.format("%s/projects/%s/latestrelease", "https://hangar.papermc.io/api/v1", hangarData.getHangarProjectSlug()));
        if (response.statusCode() != 200) {
            throw new IllegalStateException("Received invalid response code (" + response.statusCode() + ") whilst checking '" + pluginData.getPluginName() + "' for updates.");
        }
        return response.body();
    }

    @Override
    public String getDownloadUrl(PluginData pluginData, PlatformData platformData) {
        String string;
        if (platformData instanceof HangarData) {
            HangarData hangarData = (HangarData)platformData;
            string = String.format("%s/projects/%s/versions/%s/PAPER/download", "https://hangar.papermc.io/api/v1", hangarData.getHangarProjectSlug(), pluginData.getLatestVersion());
        } else {
            string = null;
        }
        return string;
    }
}

