/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.api.platform.spigot;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.http.HttpResponse;
import org.lushplugins.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pluginupdater.api.platform.spigot.SpigotData;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.api.util.HttpUtil;
import org.lushplugins.pluginupdater.api.version.VersionChecker;

public class SpigotVersionChecker
implements VersionChecker {
    @Override
    public String getLatestVersion(PluginData pluginData, PlatformData platformData) throws IOException, InterruptedException {
        if (!(platformData instanceof SpigotData)) {
            return null;
        }
        SpigotData spigotData = (SpigotData)platformData;
        HttpResponse<String> response = HttpUtil.sendRequest(String.format("%s/resources/%s/versions/latest", "https://api.spiget.org/v2", spigotData.getSpigotResourceId()));
        if (response.statusCode() != 200) {
            throw new IllegalStateException("Received invalid response code (" + response.statusCode() + ") whilst checking '" + pluginData.getPluginName() + "' for updates.");
        }
        JsonObject pluginJson = JsonParser.parseString((String)response.body()).getAsJsonObject();
        return pluginJson.get("name").getAsString();
    }

    @Override
    public String getDownloadUrl(PluginData pluginData, PlatformData platformData) {
        String string;
        if (platformData instanceof SpigotData) {
            SpigotData spigotData = (SpigotData)platformData;
            string = String.format("%s/resources/%s/download", "https://api.spiget.org/v2", spigotData.getSpigotResourceId());
        } else {
            string = null;
        }
        return string;
    }
}

