/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.collector;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.lushplugins.pluginupdater.PluginUpdater;
import org.lushplugins.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pluginupdater.api.platform.PlatformRegistry;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.collector.PluginDataCollector;
import org.lushplugins.pluginupdater.config.ConfigManager;

public class CommonPluginCollector
implements PluginDataCollector {
    @Override
    public List<PluginData> collectPlugins(Collection<JavaPlugin> unknownPlugins) {
        ConfigManager configManager = PluginUpdater.getInstance().getConfigManager();
        ArrayList<PluginData> pluginDataList = new ArrayList<PluginData>();
        InputStream commonPluginsInputStream = PluginUpdater.getInstance().getResource("common-plugins.yml");
        YamlConfiguration commonPluginsYml = commonPluginsInputStream != null ? YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(commonPluginsInputStream)) : null;
        for (Plugin plugin : unknownPlugins) {
            PlatformData platformData;
            ConfigurationSection pluginSection;
            String pluginName = plugin.getName();
            if (!configManager.canRegisterPluginData(pluginName) || commonPluginsYml == null || !commonPluginsYml.contains(pluginName) || (pluginSection = commonPluginsYml.getConfigurationSection(pluginName)) == null || (platformData = PlatformRegistry.getPlatformData(pluginSection.getString("platform"), pluginSection)) == null) continue;
            pluginDataList.add(new PluginData(plugin, platformData));
        }
        return pluginDataList;
    }
}

