/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.plugin.PluginBase;
import org.bukkit.plugin.java.JavaPlugin;
import org.lushplugins.pluginupdater.PluginUpdater;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.collector.CommonPluginCollector;
import org.lushplugins.pluginupdater.collector.ModrinthCollector;
import org.lushplugins.pluginupdater.collector.PluginYamlCollector;
import org.lushplugins.pluginupdater.collector.SpigotCollector;
import org.lushplugins.pluginupdater.config.ConfigManager;

public interface PluginDataCollector {
    public List<PluginData> collectPlugins(Collection<JavaPlugin> var1);

    public static CompletableFuture<List<PluginData>> collectUnknownPlugins() {
        CompletableFuture<List<PluginData>> future = new CompletableFuture<List<PluginData>>();
        PluginUpdater.getInstance().getUpdateHandler().getThreads().execute(() -> {
            ConfigManager configManager = PluginUpdater.getInstance().getConfigManager();
            Map<String, JavaPlugin> unknownPlugins = Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(plugin -> {
                JavaPlugin javaPlugin;
                return plugin instanceof JavaPlugin ? (javaPlugin = (JavaPlugin)plugin) : null;
            }).filter(plugin -> plugin != null && configManager.canRegisterPluginData(plugin.getName())).collect(Collectors.toMap(PluginBase::getName, plugin -> plugin));
            if (unknownPlugins.isEmpty()) {
                future.complete(Collections.emptyList());
                return;
            }
            ArrayList<PluginData> foundPluginDataList = new ArrayList<PluginData>();
            List<SpigotCollector> collectors = List.of(new CommonPluginCollector(), new PluginYamlCollector(), new ModrinthCollector(), new SpigotCollector());
            for (PluginDataCollector pluginDataCollector : collectors) {
                List<PluginData> pluginDataList = pluginDataCollector.collectPlugins(unknownPlugins.values());
                foundPluginDataList.addAll(pluginDataList);
                for (PluginData pluginData : pluginDataList) {
                    unknownPlugins.remove(pluginData.getPluginName());
                }
            }
            future.complete(foundPluginDataList);
        });
        return future;
    }
}

