/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.parameters;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.exception.InvalidPlayerException;
import revxrsal.commands.bukkit.util.BukkitVersion;
import revxrsal.commands.node.ExecutionContext;
import revxrsal.commands.parameter.ParameterType;
import revxrsal.commands.stream.MutableStringStream;
import revxrsal.commands.util.Collections;

public final class OfflinePlayerParameterType
implements ParameterType<BukkitCommandActor, OfflinePlayer> {
    private final boolean brigadierEnabled;

    public OfflinePlayerParameterType(boolean brigadierEnabled) {
        this.brigadierEnabled = brigadierEnabled;
    }

    private static boolean exists(OfflinePlayer player) {
        return player.hasPlayedBefore() || player.isOnline() || player.getFirstPlayed() != 0L;
    }

    @Override
    public OfflinePlayer parse(@NotNull MutableStringStream input, @NotNull ExecutionContext<BukkitCommandActor> context) {
        String name = input.readString();
        if (name.equals("self") || name.equals("me") || name.equals("@s")) {
            return context.actor().requirePlayer();
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)name);
        if (OfflinePlayerParameterType.exists(player)) {
            return player;
        }
        throw new InvalidPlayerException(name);
    }

    @Override
    @NotNull
    public SuggestionProvider<BukkitCommandActor> defaultSuggestions() {
        if (BukkitVersion.isBrigadierSupported() && this.brigadierEnabled) {
            return SuggestionProvider.empty();
        }
        return context -> Collections.map(Bukkit.getOnlinePlayers(), OfflinePlayer::getName);
    }
}

