/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater;

import java.io.File;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.lushplugins.pluginupdater.api.util.DownloadLogger;
import org.lushplugins.pluginupdater.command.UpdateCommand;
import org.lushplugins.pluginupdater.command.UpdaterCommand;
import org.lushplugins.pluginupdater.command.UpdatesCommand;
import org.lushplugins.pluginupdater.config.ConfigManager;
import org.lushplugins.pluginupdater.listener.PlayerListener;
import org.lushplugins.pluginupdater.updater.UpdateHandler;
import org.lushplugins.pluginupdater.util.lamp.annotation.PluginName;
import org.lushplugins.pluginupdater.util.lamp.response.StringMessageResponseHandler;
import revxrsal.commands.Lamp;
import revxrsal.commands.bukkit.BukkitLamp;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;

public final class PluginUpdater
extends JavaPlugin {
    private static PluginUpdater plugin;
    private UpdateHandler updateHandler;
    private ConfigManager configManager;

    public void onEnable() {
        plugin = this;
        DownloadLogger.setLogFile(new File(plugin.getDataFolder(), "downloads.log"));
        this.updateHandler = new UpdateHandler();
        this.updateHandler.enable();
        this.configManager = new ConfigManager();
        this.configManager.reloadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        Lamp<BukkitCommandActor> lamp = BukkitLamp.builder(this).suggestionProviders(providers -> providers.addProviderForAnnotation(PluginName.class, annotation -> context -> PluginUpdater.getInstance().getConfigManager().getPlugins())).responseHandler(String.class, new StringMessageResponseHandler()).build();
        lamp.register(new UpdaterCommand(), new UpdatesCommand());
        if (PluginUpdater.getInstance().getConfigManager().shouldAllowDownloads()) {
            lamp.register(new UpdateCommand());
        }
    }

    public void onDisable() {
        if (this.updateHandler != null) {
            this.updateHandler.shutdown();
            this.updateHandler = null;
        }
        this.configManager = null;
        plugin = null;
    }

    public UpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public static PluginUpdater getInstance() {
        return plugin;
    }
}

