/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.api.platform;

import java.util.HashMap;
import java.util.concurrent.Callable;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.pluginupdater.api.platform.Platform;
import org.lushplugins.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pluginupdater.api.platform.github.GithubData;
import org.lushplugins.pluginupdater.api.platform.github.GithubVersionChecker;
import org.lushplugins.pluginupdater.api.platform.hangar.HangarData;
import org.lushplugins.pluginupdater.api.platform.hangar.HangarVersionChecker;
import org.lushplugins.pluginupdater.api.platform.modrinth.ModrinthData;
import org.lushplugins.pluginupdater.api.platform.modrinth.ModrinthVersionChecker;
import org.lushplugins.pluginupdater.api.platform.spigot.SpigotData;
import org.lushplugins.pluginupdater.api.platform.spigot.SpigotVersionChecker;
import org.lushplugins.pluginupdater.api.version.VersionChecker;

public class PlatformRegistry {
    private static final HashMap<String, Platform> platforms = new HashMap();
    private static final HashMap<String, VersionChecker> cachedPlatformCheckers = new HashMap();

    @Nullable
    public static VersionChecker getVersionChecker(String platform) {
        return PlatformRegistry.getOrConstructVersionChecker(platform);
    }

    @Nullable
    public static PlatformData getPlatformData(String platform, ConfigurationSection configurationSection) {
        try {
            return platforms.containsKey(platform) ? platforms.get(platform).platformDataConstructor().apply(configurationSection) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void register(@NotNull String platform, int rateLimit, @NotNull Callable<VersionChecker> updater, @NotNull PlatformDataConstructor platformDataConstructor) {
        if (platforms.containsKey(platform)) {
            throw new IllegalStateException("This platform is already registered");
        }
        platforms.put(platform, new Platform(rateLimit, updater, platformDataConstructor));
    }

    public static void register(@NotNull String platform, @NotNull Callable<VersionChecker> updater, @NotNull PlatformDataConstructor platformDataConstructor) {
        PlatformRegistry.register(platform, 1, updater, platformDataConstructor);
    }

    public static void unregister(String platform) {
        platforms.remove(platform);
    }

    @Nullable
    private static VersionChecker getOrConstructVersionChecker(@NotNull String platform) {
        if (cachedPlatformCheckers.containsKey(platform)) {
            return cachedPlatformCheckers.get(platform);
        }
        if (platforms.containsKey(platform)) {
            try {
                VersionChecker versionChecker = platforms.get(platform).updater().call();
                cachedPlatformCheckers.put(platform, versionChecker);
                return versionChecker;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    static {
        PlatformRegistry.register("github", -1, GithubVersionChecker::new, GithubData::new);
        PlatformRegistry.register("hangar", 1, HangarVersionChecker::new, HangarData::new);
        PlatformRegistry.register("modrinth", 1, ModrinthVersionChecker::new, ModrinthData::new);
        PlatformRegistry.register("spigot", 1, SpigotVersionChecker::new, SpigotData::new);
    }

    @FunctionalInterface
    public static interface PlatformDataConstructor {
        public PlatformData apply(ConfigurationSection var1);
    }
}

