/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.api.platform.modrinth;

import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.pluginupdater.api.platform.PlatformData;

public class ModrinthData
extends PlatformData {
    private static final String NAME = "modrinth";
    private final String modrinthProjectId;
    @Nullable
    private final List<String> versionTypes;
    private final boolean featuredOnly;

    public ModrinthData(ConfigurationSection configurationSection) {
        super(NAME);
        this.modrinthProjectId = configurationSection.getString("modrinth-project-id");
        this.versionTypes = configurationSection.isString("channels") ? Collections.singletonList(configurationSection.getString("channels", "release").toLowerCase()) : (configurationSection.isList("channels") ? configurationSection.getStringList("channels").stream().map(String::toLowerCase).toList() : null);
        this.featuredOnly = configurationSection.getBoolean("featured-only");
    }

    public ModrinthData(String modrinthProjectId, @Nullable List<String> versionTypes, boolean featuredOnly) {
        super(NAME);
        this.modrinthProjectId = modrinthProjectId;
        this.versionTypes = versionTypes;
        this.featuredOnly = featuredOnly;
    }

    public ModrinthData(String modrinthProjectId, @Nullable String versionType, boolean featuredOnly) {
        this(modrinthProjectId, Collections.singletonList(versionType), featuredOnly);
    }

    public ModrinthData(String modrinthProjectId, boolean featuredOnly) {
        this(modrinthProjectId, VersionType.ALL, featuredOnly);
    }

    public String getModrinthProjectId() {
        return this.modrinthProjectId;
    }

    public boolean specifiesVersionType() {
        return this.versionTypes != null;
    }

    @ApiStatus.Internal
    @Nullable
    public String getVersionType() {
        return this.versionTypes != null ? this.versionTypes.get(0) : null;
    }

    @Nullable
    public List<String> getVersionTypes() {
        return this.versionTypes;
    }

    public boolean includeFeaturedOnly() {
        return this.featuredOnly;
    }

    public static class VersionType {
        public static final List<String> ALL = null;
        public static final String RELEASE = "release";
        public static final String BETA = "beta";
        public static final String ALPHA = "alpha";
    }
}

