/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.api.platform.modrinth;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.http.HttpResponse;
import org.lushplugins.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pluginupdater.api.platform.modrinth.ModrinthData;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.api.util.HttpUtil;
import org.lushplugins.pluginupdater.api.version.VersionChecker;

public class ModrinthVersionChecker
implements VersionChecker {
    @Override
    public String getLatestVersion(PluginData pluginData, PlatformData platformData) throws IOException, InterruptedException {
        if (!(platformData instanceof ModrinthData)) {
            return null;
        }
        ModrinthData modrinthData = (ModrinthData)platformData;
        JsonObject currVersionJson = this.getLatestVersion(pluginData, modrinthData);
        return currVersionJson.get("version_number").getAsString();
    }

    @Override
    public String getDownloadUrl(PluginData pluginData, PlatformData platformData) throws IOException, InterruptedException {
        if (!(platformData instanceof ModrinthData)) {
            return null;
        }
        ModrinthData modrinthData = (ModrinthData)platformData;
        JsonObject currVersionJson = this.getLatestVersion(pluginData, modrinthData);
        return currVersionJson.get("files").getAsJsonArray().get(0).getAsJsonObject().get("url").getAsString();
    }

    private JsonArray getVersions(PluginData pluginData, ModrinthData modrinthData) throws IOException, InterruptedException {
        HttpResponse<String> response;
        StringBuilder uriBuilder = new StringBuilder(String.format("%s/project/%s/version", "https://api.modrinth.com/v2", modrinthData.getModrinthProjectId())).append("?loaders=[%22bukkit%22,%22spigot%22,%22paper%22,%22purpur%22,%22folia%22]");
        if (modrinthData.specifiesVersionType()) {
            uriBuilder.append("&version_type=").append(modrinthData.getVersionType());
        }
        if (modrinthData.includeFeaturedOnly()) {
            uriBuilder.append("&featured=true");
        }
        if ((response = HttpUtil.sendRequest(uriBuilder.toString())).statusCode() != 200) {
            throw new IllegalStateException("Received invalid response code (%s) whilst checking '%s' for updates.".formatted(response.statusCode(), pluginData.getPluginName()));
        }
        return JsonParser.parseString((String)response.body()).getAsJsonArray();
    }

    private JsonObject getLatestVersion(PluginData pluginData, ModrinthData modrinthData) throws IOException, InterruptedException {
        JsonArray versions = this.getVersions(pluginData, modrinthData);
        if (versions.isEmpty()) {
            throw new IllegalStateException("Failed to collect versions for '%s'".formatted(pluginData.getPluginName()));
        }
        return versions.get(0).getAsJsonObject();
    }
}

