/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.api.util;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdaterConstants {
    public static final String VERSION;
    public static final Logger LOGGER;
    public static final Gson GSON;

    static {
        LOGGER = Logger.getLogger("PluginUpdater");
        GSON = new Gson();
        Properties properties = new Properties();
        try (InputStream inputStream = UpdaterConstants.class.getClassLoader().getResourceAsStream("settings.properties");){
            properties.load(inputStream);
            VERSION = properties.getProperty("version");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to access properties file");
            throw new IllegalStateException("Failed to access 'settings.properties' resource.");
        }
    }

    public static class Endpoint {
        public static final String MODRINTH = "https://api.modrinth.com/v2";
        public static final String SPIGET = "https://api.spiget.org/v2";
        public static final String HANGAR = "https://hangar.papermc.io/api/v1";
        public static final String GITHUB = "https://api.github.com";
    }
}

