/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.collector;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.pluginupdater.PluginUpdater;
import org.lushplugins.pluginupdater.api.platform.modrinth.ModrinthData;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.api.util.HttpUtil;
import org.lushplugins.pluginupdater.api.util.UpdaterConstants;
import org.lushplugins.pluginupdater.collector.PluginDataCollector;

public class ModrinthCollector
implements PluginDataCollector {
    @Override
    public List<PluginData> collectPlugins(Collection<JavaPlugin> unknownPlugins) {
        HttpResponse<String> response;
        HashMap<String, JavaPlugin> pluginHashes = new HashMap<String, JavaPlugin>();
        for (JavaPlugin unknownPlugin : unknownPlugins) {
            File pluginFile = this.getPluginFile(unknownPlugin);
            if (pluginFile == null) continue;
            try {
                HashCode hash2 = Files.asByteSource((File)pluginFile).hash(Hashing.sha512());
                pluginHashes.put(hash2.toString(), unknownPlugin);
            }
            catch (IOException e) {
                PluginUpdater.getInstance().getLogger().log(Level.WARNING, "Caught error whilst hashing plugin file: ", e);
            }
        }
        if (pluginHashes.isEmpty()) {
            return Collections.emptyList();
        }
        JsonObject payload = new JsonObject();
        payload.addProperty("algorithm", "sha512");
        payload.add("hashes", (JsonElement)UpdaterConstants.GSON.toJsonTree(pluginHashes.keySet()).getAsJsonArray());
        try {
            response = HttpUtil.sendRequest(String.format("%s/version_files", "https://api.modrinth.com/v2"), (JsonElement)payload);
        }
        catch (IOException | InterruptedException e) {
            PluginUpdater.getInstance().getLogger().log(Level.WARNING, "Caught error whilst getting project data from hashes: ", e);
            return Collections.emptyList();
        }
        if (response.statusCode() != 200) {
            PluginUpdater.getInstance().getLogger().log(Level.WARNING, "Received invalid response code (" + response.statusCode() + ") whilst getting project data from hashes.");
            return Collections.emptyList();
        }
        ArrayList<PluginData> pluginDataList = new ArrayList<PluginData>();
        JsonObject versionsJson = JsonParser.parseString((String)response.body()).getAsJsonObject();
        pluginHashes.forEach((hash, plugin) -> {
            JsonObject versionJson = versionsJson.getAsJsonObject(hash);
            if (versionJson == null) {
                return;
            }
            String projectId = versionJson.get("project_id").getAsString();
            pluginDataList.add(new PluginData((Plugin)plugin, new ModrinthData(projectId, true)));
        });
        return pluginDataList;
    }

    @Nullable
    private File getPluginFile(JavaPlugin plugin) {
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            method.setAccessible(true);
            return (File)method.invoke((Object)plugin, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            PluginUpdater.getInstance().getLogger().log(Level.WARNING, "Caught error whilst getting plugin file: ", e);
            return null;
        }
    }
}

