/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.collector;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.pluginupdater.PluginUpdater;
import org.lushplugins.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pluginupdater.api.platform.spigot.SpigotData;
import org.lushplugins.pluginupdater.api.updater.PluginData;
import org.lushplugins.pluginupdater.api.util.HttpUtil;
import org.lushplugins.pluginupdater.collector.PluginDataCollector;

public class SpigotCollector
implements PluginDataCollector {
    @Override
    public List<PluginData> collectPlugins(Collection<JavaPlugin> unknownPlugins) {
        ArrayList<PluginData> pluginDataList = new ArrayList<PluginData>();
        for (JavaPlugin unknownPlugin : unknownPlugins) {
            PluginData pluginData = this.collectPlugin(unknownPlugin);
            if (pluginData == null) continue;
            pluginDataList.add(pluginData);
        }
        return pluginDataList;
    }

    @Nullable
    private PluginData collectPlugin(JavaPlugin unknownPlugin) {
        HttpResponse<String> response;
        try {
            response = HttpUtil.sendRequest(String.format("%s/search/resources/%s", "https://api.spiget.org/v2", unknownPlugin.getName()));
        }
        catch (IOException | InterruptedException e) {
            PluginUpdater.getInstance().getLogger().log(Level.WARNING, "Caught error whilst searching for project on spiget: ", e);
            return null;
        }
        if (response.statusCode() == 404) {
            return null;
        }
        if (response.statusCode() != 200) {
            PluginUpdater.getInstance().getLogger().log(Level.WARNING, "Received invalid response code (%s) whilst searching for project on spiget (%s)".formatted(response.statusCode(), response.uri()));
            return null;
        }
        JsonArray resultsJson = JsonParser.parseString((String)response.body()).getAsJsonArray();
        if (resultsJson.size() != 1) {
            return null;
        }
        JsonObject resultJson = resultsJson.get(0).getAsJsonObject();
        return new PluginData((Plugin)unknownPlugin, (PlatformData)new SpigotData(resultJson.get("id").getAsString()), false);
    }
}

