/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pluginupdater.command;

import java.util.ArrayList;
import java.util.List;
import org.lushplugins.pluginupdater.PluginUpdater;
import org.lushplugins.pluginupdater.api.version.VersionDifference;
import org.lushplugins.pluginupdater.config.ConfigManager;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.bukkit.annotation.CommandPermission;

public class UpdatesCommand {
    @Command(value={"updater updates", "updates"})
    @CommandPermission(value="pluginupdater.checkupdates")
    public String updates() {
        ConfigManager configManager = PluginUpdater.getInstance().getConfigManager();
        List<String> plugins = configManager.getAllPluginData().stream().map(pluginData -> {
            String pluginName = pluginData.getPluginName();
            VersionDifference versionDifference = pluginData.getVersionDifference();
            if (!pluginData.hasCheckRan()) {
                return configManager.getMessage("unchecked-color", "&8") + pluginName;
            }
            if (pluginData.isAlreadyDownloaded()) {
                return configManager.getMessage("latest-version-color", "&#b7faa2") + pluginName + configManager.getMessage("update-prepared-color", "&#ffda54") + "*";
            }
            if (versionDifference.equals((Object)VersionDifference.MAJOR)) {
                return configManager.getMessage("major-update-available-color", "&#ff6969") + pluginName;
            }
            if (versionDifference.equals((Object)VersionDifference.MINOR) || versionDifference.equals((Object)VersionDifference.BUG_FIXES) || versionDifference.equals((Object)VersionDifference.BUILD)) {
                return configManager.getMessage("update-available-color", "&#ffda54") + pluginName;
            }
            return configManager.getMessage("latest-version-color", "&#b7faa2") + pluginName;
        }).toList();
        if (!plugins.isEmpty()) {
            return "&fRegistered Plugins (%s):\n%s".formatted(plugins.size(), String.join((CharSequence)"&7, ", plugins));
        }
        return "&#ff6969Could not find any registered plugins in PluginUpdater";
    }

    @Command(value={"updater updates list", "updates list"})
    @CommandPermission(value="pluginupdater.checkupdates")
    public String list() {
        ConfigManager configManager = PluginUpdater.getInstance().getConfigManager();
        String updateAvailableColor = configManager.getMessage("update-available-color", "&#ffda54");
        String majorUpdateAvailableColor = configManager.getMessage("major-update-available-color", "&#ff6969");
        String latestVersionColor = configManager.getMessage("latest-version-color", "&#b7faa2");
        ArrayList plugins = new ArrayList();
        configManager.getAllPluginData().forEach(pluginData -> {
            VersionDifference versionDifference = pluginData.getVersionDifference();
            if (!pluginData.isAlreadyDownloaded() && (versionDifference.equals((Object)VersionDifference.LATEST) || versionDifference.equals((Object)VersionDifference.UNKNOWN))) {
                return;
            }
            String message = "&f" + pluginData.getPluginName() + ": &7" + pluginData.getCurrentVersion() + " &f-> " + (versionDifference.equals((Object)VersionDifference.MAJOR) ? majorUpdateAvailableColor : updateAvailableColor) + pluginData.getLatestVersion();
            if (pluginData.isAlreadyDownloaded()) {
                message = message + latestVersionColor + " \u1d05\u1d0f\u1d21\u0274\u029f\u1d0f\u1d00\u1d05\u1d07\u1d05";
            }
            plugins.add(message);
        });
        if (!plugins.isEmpty()) {
            return String.join((CharSequence)"&r\n", plugins);
        }
        return "&#ff6969No updates found";
    }
}

