/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.signalerts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.UUID;
import net.a5ho9999.signalerts.commands.SignAlertCommandRegistry;
import net.a5ho9999.signalerts.config.SignAlertConfig;
import net.a5ho9999.signalerts.data.PlayerPreferences;
import net.a5ho9999.signalerts.events.AreaSignAlertWorldEvents;
import net.a5ho9999.signalerts.handlers.SignAlertAreaManager;
import net.a5ho9999.signalerts.handlers.SignAlertAreaTickHandler;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignAlerts
implements ModInitializer {
    public static final String MOD_ID = "signalerts";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"signalerts");
    public static final SignAlertConfig CONFIG = SignAlerts.loadGeneralConfig();
    private static SignAlertAreaTickHandler tickHandler;
    private static AreaSignAlertWorldEvents signEvents;
    private static MinecraftServer currentServer;

    public void onInitialize() {
        try {
            CONFIG.validate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        tickHandler = new SignAlertAreaTickHandler();
        signEvents = new AreaSignAlertWorldEvents(tickHandler);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> SignAlertCommandRegistry.register((CommandDispatcher<class_2168>)dispatcher));
        ServerTickEvents.END_SERVER_TICK.register((Object)tickHandler);
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            if (world.method_8510() % 20L == 0L) {
                signEvents.processPendingSigns(world);
                signEvents.scanAroundPlayers(world);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            currentServer = server;
            LOGGER.info("Scanning world spawn areas for waxed signs...");
            server.method_3738().forEach(signEvents::scanWorldSpawn);
            SignAlerts.loadPlayerPreferences();
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> server.execute(() -> {
            LOGGER.info("Player {} joined, scanning their loaded chunks...", (Object)handler.field_14140.method_5477().getString());
            signEvents.scanPlayerLoadedChunks(handler.field_14140);
        }));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            SignAlerts.savePlayerPreferences();
            tickHandler.cleanup();
            currentServer = null;
        });
    }

    public static SignAlertAreaTickHandler getTickHandler() {
        return tickHandler;
    }

    public static AreaSignAlertWorldEvents getSignEvents() {
        return signEvents;
    }

    public static void savePlayerPreferences() {
        if (currentServer != null) {
            PlayerPreferences preferences = PlayerPreferences.getOrCreate(currentServer);
            for (Map.Entry<UUID, Boolean> entry : tickHandler.getPlayerTracker().getPlayerVisibilityMap().entrySet()) {
                preferences.setPlayerVisibility(entry.getKey(), entry.getValue());
            }
            for (class_3218 world : currentServer.method_3738()) {
                SignAlertAreaManager manager = tickHandler.getOrCreateManager(world);
                for (Map.Entry<UUID, Boolean> entry : manager.getBeamManager().getPlayerBeamVisibilityMap().entrySet()) {
                    preferences.setBeamVisibility(entry.getKey(), entry.getValue());
                }
            }
            LOGGER.info("Saved player area preferences");
        }
    }

    private static void loadPlayerPreferences() {
        if (currentServer != null) {
            PlayerPreferences preferences = PlayerPreferences.getOrCreate(currentServer);
            tickHandler.getPlayerTracker().loadPlayerVisibility(preferences.getPlayerVisibility());
            for (class_3218 world : currentServer.method_3738()) {
                SignAlertAreaManager manager = tickHandler.getOrCreateManager(world);
                manager.getBeamManager().loadPlayerBeamVisibility(preferences.getBeamVisibility());
            }
            LOGGER.info("Loaded player area preferences");
        }
    }

    @NotNull
    private static SignAlertConfig loadGeneralConfig() {
        SignAlertConfig config = new SignAlertConfig();
        try {
            File configFile = new File("config/signalerts.json");
            if (configFile.exists()) {
                Gson gson = new Gson();
                FileReader reader = new FileReader(configFile);
                config = (SignAlertConfig)gson.fromJson((Reader)reader, SignAlertConfig.class);
                ((Reader)reader).close();
            } else {
                boolean ignoredFile = configFile.getParentFile().mkdirs();
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                FileWriter writer = new FileWriter(configFile);
                gson.toJson((Object)config, (Appendable)writer);
                ((Writer)writer).close();
            }
        }
        catch (Exception e) {
            LOGGER.info("Failed to load general config: {}", (Object)String.valueOf(e));
        }
        config.checkVersion();
        return config;
    }
}

