/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.signalerts.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.a5ho9999.signalerts.SignAlerts;
import net.a5ho9999.signalerts.commands.SignAlertListCommands;
import net.a5ho9999.signalerts.commands.SignAlertModeTypeCommands;
import net.a5ho9999.signalerts.commands.SignAlertSettingCommands;
import net.a5ho9999.signalerts.data.DisplayMode;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class SignAlertCommandRegistry {
    private static final SuggestionProvider<class_2168> MODE_SUGGESTIONS = (context, builder) -> class_2172.method_9253((String[])new String[]{"actionBar", "title", "bossBar"}, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> TITLE_TYPE_SUGGESTIONS = (context, builder) -> class_2172.method_9253((String[])new String[]{"title", "subtitle"}, (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"areaDisplay").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"allowDarkText").then(class_2170.method_9244((String)"allow", (ArgumentType)BoolArgumentType.bool()).executes(SignAlertSettingCommands::executeSetAllowDarkText))).executes(SignAlertSettingCommands::executeGetAllowDarkText))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"glowBeams").then(class_2170.method_9244((String)"allow", (ArgumentType)BoolArgumentType.bool()).executes(SignAlertSettingCommands::executeSetAllowGlowBeams))).executes(SignAlertSettingCommands::executeGetGlowBeams))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"maxRadius").then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)500)).executes(SignAlertSettingCommands::executeSetMaxRadius))).executes(SignAlertSettingCommands::executeGetMaxRadius))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"mode").executes(SignAlertModeTypeCommands::executeGetMode)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests(MODE_SUGGESTIONS).executes(SignAlertCommandRegistry::executeSignCommand)).then(class_2170.method_9244((String)"titleType", (ArgumentType)StringArgumentType.word()).suggests(TITLE_TYPE_SUGGESTIONS).executes(SignAlertModeTypeCommands::executeSetTitleType))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"waxedRequired").then(class_2170.method_9244((String)"require", (ArgumentType)BoolArgumentType.bool()).executes(SignAlertSettingCommands::executeSetWaxedRequirement))).executes(SignAlertSettingCommands::executeGetWaxedRequirement))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").then(class_2170.method_9247((String)"all").executes(SignAlertListCommands::executeListAll))).then(class_2170.method_9247((String)"within").then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(context -> SignAlertListCommands.executeListWithin((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))))).then(class_2170.method_9247((String)"page").then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> SignAlertListCommands.executeListPage((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"page"))))))).executes(SignAlertModeTypeCommands::executeGetMode));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"areaToggle").then(class_2170.method_9247((String)"areaNotice").executes(SignAlertSettingCommands::executeToggleAreaNotice))).then(class_2170.method_9247((String)"particleDisplay").executes(SignAlertSettingCommands::executeToggleParticleDisplay)));
    }

    public static int executeSignCommand(CommandContext<class_2168> context) {
        DisplayMode newMode;
        String modeArg = StringArgumentType.getString(context, (String)"mode").toLowerCase();
        if (modeArg.equals("maxradius")) {
            return SignAlertSettingCommands.executeGetMaxRadius(context);
        }
        if (modeArg.equals("allowdarktext")) {
            return SignAlertSettingCommands.executeGetAllowDarkText(context);
        }
        try {
            newMode = switch (modeArg) {
                case "actionbar", "action" -> DisplayMode.ACTION_BAR;
                case "title" -> DisplayMode.TITLE;
                case "bossbar", "boss" -> DisplayMode.BOSS_BAR;
                default -> throw new IllegalArgumentException("Invalid mode");
            };
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid display mode! Use: actionbar, title, or bossbar").method_27692(class_124.field_1061));
            return 0;
        }
        SignAlerts.getTickHandler().getPlayerTracker().setDisplayMode(newMode);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Area display mode set to: ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)newMode.name()).method_27692(class_124.field_1054)), true);
        return 1;
    }
}

