/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.signalerts.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.a5ho9999.signalerts.SignAlerts;
import net.a5ho9999.signalerts.data.ListContext;
import net.a5ho9999.signalerts.data.SignAreaAlert;
import net.a5ho9999.signalerts.handlers.SignAlertAreaManager;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class SignAlertListCommands {
    private static final int ENTRIES_PER_PAGE = 10;
    private static final Map<UUID, ListContext> playerContextMap = new HashMap<UUID, ListContext>();

    public static int executeListAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_2338 currentPos = player.method_24515();
        playerContextMap.put(player.method_5667(), new ListContext(-1, currentPos));
        return SignAlertListCommands.executeList(context, -1, currentPos, 1);
    }

    public static int executeListWithin(CommandContext<class_2168> context, int radius) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_2338 currentPos = player.method_24515();
        playerContextMap.put(player.method_5667(), new ListContext(radius, currentPos));
        return SignAlertListCommands.executeList(context, radius, currentPos, 1);
    }

    public static int executeListPage(CommandContext<class_2168> context, int page) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        ListContext listContext = playerContextMap.getOrDefault(player.method_5667(), new ListContext(-1, player.method_24515()));
        return SignAlertListCommands.executeList(context, listContext.radius(), listContext.position(), page);
    }

    private static int executeList(CommandContext<class_2168> context, int maxDistance, class_2338 referencePos, int page) {
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        SignAlertAreaManager manager = SignAlerts.getTickHandler().getOrCreateManager(world);
        ArrayList<SignAreaAlert> areas = new ArrayList<SignAreaAlert>();
        for (SignAreaAlert area2 : SignAlertListCommands.getAllAreas(manager)) {
            if (maxDistance >= 0 && !area2.signPos().method_19771((class_2382)referencePos, (double)maxDistance)) continue;
            areas.add(area2);
        }
        if (areas.isEmpty()) {
            Object message = maxDistance < 0 ? "No area signs found in this world." : "No area signs found within " + maxDistance + " blocks.";
            source.method_9213((class_2561)class_2561.method_43470((String)message));
            return 0;
        }
        areas.sort(Comparator.comparingDouble(area -> Math.sqrt(area.signPos().method_10262((class_2382)referencePos))));
        int totalPages = (int)Math.ceil((double)areas.size() / 10.0);
        int currentPage = Math.max(1, Math.min(page, totalPages));
        SignAlertListCommands.sendPage(source, areas, currentPage, totalPages, referencePos, maxDistance);
        return areas.size();
    }

    private static void sendPage(class_2168 source, List<SignAreaAlert> areas, int page, int totalPages, class_2338 playerPos, int maxDistance) {
        int startIndex = (page - 1) * 10;
        int endIndex = Math.min(startIndex + 10, areas.size());
        class_5250 header = class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n").method_27692(class_124.field_1063);
        String title = maxDistance < 0 ? "Area Signs (Page " + page + "/" + totalPages + ")" : "Area Signs within " + maxDistance + " blocks (Page " + page + "/" + totalPages + ")";
        header.method_10852((class_2561)class_2561.method_43470((String)(title + "\n")).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        header.method_10852((class_2561)class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n").method_27692(class_124.field_1063));
        source.method_9226(() -> header, false);
        for (int i = startIndex; i < endIndex; ++i) {
            SignAreaAlert area = areas.get(i);
            class_2338 signPos = area.signPos();
            double distance = Math.sqrt(signPos.method_10262((class_2382)playerPos));
            class_5250 entry = class_2561.method_43470((String)"");
            class_5250 posText = class_2561.method_43470((String)("[" + signPos.method_10263() + ", " + signPos.method_10264() + ", " + signPos.method_10260() + "]")).method_27695(new class_124[]{class_124.field_1075, class_124.field_1073}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/tp @s " + signPos.method_10263() + " " + signPos.method_10264() + " " + signPos.method_10260())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to teleport").method_27692(class_124.field_1060))));
            entry.method_10852((class_2561)posText);
            entry.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063));
            entry.method_10852((class_2561)class_2561.method_43470((String)area.displayText().getString()).method_27692(class_124.field_1054));
            entry.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063));
            String radiusInfo = "R: " + area.effectiveRadius();
            if (area.effectiveRadius() != area.originalRadius()) {
                radiusInfo = radiusInfo + " (" + area.originalRadius() + ")";
            }
            entry.method_10852((class_2561)class_2561.method_43470((String)radiusInfo).method_27692(class_124.field_1060));
            entry.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063));
            entry.method_10852((class_2561)class_2561.method_43470((String)String.format("%.1f blocks away", distance)).method_27692(class_124.field_1080));
            source.method_9226(() -> entry, false);
        }
        if (totalPages > 1) {
            class_5250 footer = class_2561.method_43470((String)"\n");
            if (page > 1) {
                footer.method_10852((class_2561)class_2561.method_43470((String)"[\u25c4 Previous]").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/areaDisplay list page " + (page - 1))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Go to page " + (page - 1))).method_27692(class_124.field_1060)))));
            } else {
                footer.method_10852((class_2561)class_2561.method_43470((String)"[\u25c4 Previous]").method_27692(class_124.field_1063));
            }
            footer.method_10852((class_2561)class_2561.method_43470((String)"  "));
            if (page < totalPages) {
                footer.method_10852((class_2561)class_2561.method_43470((String)"[Next \u25ba]").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/areaDisplay list page " + (page + 1))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Go to page " + (page + 1))).method_27692(class_124.field_1060)))));
            } else {
                footer.method_10852((class_2561)class_2561.method_43470((String)"[Next \u25ba]").method_27692(class_124.field_1063));
            }
            source.method_9226(() -> footer, false);
        }
        class_5250 bottom = class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1063);
        source.method_9226(() -> bottom, false);
    }

    private static List<SignAreaAlert> getAllAreas(SignAlertAreaManager manager) {
        return new ArrayList<SignAreaAlert>(manager.getAllAreas());
    }
}

